/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.conn.scheme;

import java.util.Locale;
import org.apache.http.nio.conn.scheme.LayeringStrategy;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@Deprecated
public final class AsyncScheme {
    private final String name;
    private final LayeringStrategy strategy;
    private final int defaultPort;
    private String stringRep;

    public AsyncScheme(String name, int port2, LayeringStrategy strategy) {
        Args.notNull(name, "Scheme name");
        if (port2 <= 0 || port2 > 65535) {
            throw new IllegalArgumentException("Port is invalid: " + port2);
        }
        this.name = name.toLowerCase(Locale.ROOT);
        this.strategy = strategy;
        this.defaultPort = port2;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    public final LayeringStrategy getLayeringStrategy() {
        return this.strategy;
    }

    public final String getName() {
        return this.name;
    }

    public final int resolvePort(int port2) {
        return port2 <= 0 ? this.defaultPort : port2;
    }

    public final String toString() {
        if (this.stringRep == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name);
            buffer.append(':');
            buffer.append(Integer.toString(this.defaultPort));
            this.stringRep = buffer.toString();
        }
        return this.stringRep;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AsyncScheme) {
            AsyncScheme that = (AsyncScheme)obj;
            return this.name.equals(that.name) && this.defaultPort == that.defaultPort && this.strategy.equals(that.strategy);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.defaultPort);
        hash = LangUtils.hashCode(hash, this.name);
        hash = LangUtils.hashCode(hash, this.strategy);
        return hash;
    }
}

