/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriPatternMatcher<T> {
    private final Map<String, T> map = new LinkedHashMap<String, T>();

    public synchronized Set<Map.Entry<String, T>> entrySet() {
        return new HashSet<Map.Entry<String, T>>(this.map.entrySet());
    }

    public synchronized void register(String pattern2, T obj) {
        Args.notNull(pattern2, "URI request pattern");
        this.map.put(pattern2, obj);
    }

    public synchronized void unregister(String pattern2) {
        if (pattern2 == null) {
            return;
        }
        this.map.remove(pattern2);
    }

    @Deprecated
    public synchronized void setHandlers(Map<String, T> map2) {
        Args.notNull(map2, "Map of handlers");
        this.map.clear();
        this.map.putAll(map2);
    }

    @Deprecated
    public synchronized void setObjects(Map<String, T> map2) {
        Args.notNull(map2, "Map of handlers");
        this.map.clear();
        this.map.putAll(map2);
    }

    @Deprecated
    public synchronized Map<String, T> getObjects() {
        return this.map;
    }

    public synchronized T lookup(String path2) {
        Args.notNull(path2, "Request path");
        T obj = this.map.get(path2);
        if (obj == null) {
            String bestMatch = null;
            for (String pattern2 : this.map.keySet()) {
                if (!this.matchUriRequestPattern(pattern2, path2) || bestMatch != null && bestMatch.length() >= pattern2.length() && (bestMatch.length() != pattern2.length() || !pattern2.endsWith("*"))) continue;
                obj = this.map.get(pattern2);
                bestMatch = pattern2;
            }
        }
        return obj;
    }

    protected boolean matchUriRequestPattern(String pattern2, String path2) {
        if (pattern2.equals("*")) {
            return true;
        }
        return pattern2.endsWith("*") && path2.startsWith(pattern2.substring(0, pattern2.length() - 1)) || pattern2.startsWith("*") && path2.endsWith(pattern2.substring(1, pattern2.length()));
    }

    public String toString() {
        return this.map.toString();
    }
}

