/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Collection;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.PropertySource;

@ServiceProvider(value=PropertySource.class, resolution="optional")
public class SystemPropertiesPropertySource
implements PropertySource {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int DEFAULT_PRIORITY = 0;
    private static final String PREFIX = "log4j2.";
    private static final PropertySource INSTANCE = new SystemPropertiesPropertySource();

    public static PropertySource provider() {
        return INSTANCE;
    }

    public static String getSystemProperty(String key2, String defaultValue) {
        String value2 = INSTANCE.getProperty(key2);
        return value2 != null ? value2 : defaultValue;
    }

    private static void logException(SecurityException error2) {
        LOGGER.error("The Java system properties are not available to Log4j due to security restrictions.", (Throwable)error2);
    }

    private static void logException(SecurityException error2, String key2) {
        LOGGER.error("The Java system property {} is not available to Log4j due to security restrictions.", (Object)key2, (Object)error2);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(BiConsumer<String, String> action) {
        Object[] properties;
        try {
            properties = System.getProperties();
        }
        catch (SecurityException e2) {
            SystemPropertiesPropertySource.logException(e2);
            return;
        }
        Object[] objectArray = properties;
        synchronized (properties) {
            Object[] keySet = properties.keySet().toArray();
            // ** MonitorExit[var4_5] (shouldn't be in output)
            for (Object key2 : keySet) {
                String keyStr = Objects.toString(key2, null);
                action.accept(keyStr, properties.getProperty(keyStr));
            }
            return;
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        return PREFIX + PropertySource.Util.joinAsCamelCase(tokens);
    }

    @Override
    public Collection<String> getPropertyNames() {
        try {
            return System.getProperties().stringPropertyNames();
        }
        catch (SecurityException e2) {
            SystemPropertiesPropertySource.logException(e2);
            return PropertySource.super.getPropertyNames();
        }
    }

    @Override
    public String getProperty(String key2) {
        try {
            return System.getProperty(key2);
        }
        catch (SecurityException e2) {
            SystemPropertiesPropertySource.logException(e2, key2);
            return PropertySource.super.getProperty(key2);
        }
    }

    @Override
    public boolean containsProperty(String key2) {
        return this.getProperty(key2) != null;
    }
}

