/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.slf4j.MDC;

public class MDCContextMap
implements CleanableThreadContextMap {
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);

    @Override
    public void put(String key2, String value2) {
        MDC.put(key2, value2);
    }

    @Override
    public void putAll(Map<String, String> m4) {
        for (Map.Entry<String, String> entry : m4.entrySet()) {
            MDC.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String get(String key2) {
        return MDC.get(key2);
    }

    @Override
    public void remove(String key2) {
        MDC.remove(key2);
    }

    @Override
    public void removeAll(Iterable<String> keys2) {
        for (String key2 : keys2) {
            MDC.remove(key2);
        }
    }

    @Override
    public void clear() {
        MDC.clear();
    }

    @Override
    public boolean containsKey(String key2) {
        Map<String, String> map2 = MDC.getCopyOfContextMap();
        return map2 != null && map2.containsKey(key2);
    }

    @Override
    public Map<String, String> getCopy() {
        HashMap contextMap = MDC.getCopyOfContextMap();
        return contextMap != null ? contextMap : new HashMap();
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public boolean isEmpty() {
        Map<String, String> map2 = MDC.getCopyOfContextMap();
        return map2 == null || map2.isEmpty();
    }

    @Override
    public StringMap getReadOnlyContextData() {
        Map<String, String> copy2 = this.getCopy();
        if (copy2.isEmpty()) {
            return EMPTY_CONTEXT_DATA;
        }
        SortedArrayStringMap result2 = new SortedArrayStringMap();
        for (Map.Entry<String, String> entry : copy2.entrySet()) {
            result2.putValue(entry.getKey(), entry.getValue());
        }
        return result2;
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
    }
}

