/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent;

import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public abstract class SshAgentKeyConstraint {
    public static final SshAgentKeyConstraint CONFIRM = new SshAgentKeyConstraint(2){};
    private final byte id;

    protected SshAgentKeyConstraint(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public void put(Buffer buffer) {
        buffer.putByte(this.id);
    }

    public static class FidoProviderExtension
    extends Extension {
        private final String provider;

        public FidoProviderExtension(String provider2) {
            super("sk-provider@openssh.com");
            if (GenericUtils.isEmpty(provider2)) {
                throw new IllegalArgumentException("FIDO provider library path must be non-empty");
            }
            this.provider = provider2;
        }

        @Override
        public void put(Buffer buffer) {
            super.put(buffer);
            buffer.putString(this.provider);
        }
    }

    public static abstract class Extension
    extends SshAgentKeyConstraint {
        private final String name;

        protected Extension(String name) {
            super((byte)-1);
            if (GenericUtils.isEmpty(name)) {
                throw new IllegalArgumentException("Key constraint extension name must be non-empty");
            }
            this.name = name;
        }

        @Override
        public void put(Buffer buffer) {
            super.put(buffer);
            buffer.putString(this.name);
        }
    }

    public static class LifeTime
    extends SshAgentKeyConstraint {
        private final int secondsToLive;

        public LifeTime(int secondsToLive) {
            super((byte)1);
            if (secondsToLive <= 0) {
                throw new IllegalArgumentException("Key lifetime must be > 0, was " + secondsToLive);
            }
            this.secondsToLive = secondsToLive;
        }

        @Override
        public void put(Buffer buffer) {
            super.put(buffer);
            buffer.putUInt(this.secondsToLive);
        }
    }
}

