/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractAgentClient
extends AbstractLoggingBean {
    private final Buffer buffer = new ByteArrayBuffer();
    private final SshAgent agent;

    protected AbstractAgentClient(SshAgent agent) {
        this.agent = agent;
    }

    public synchronized void messageReceived(Buffer message) throws IOException {
        this.buffer.putBuffer(message);
        int avail = this.buffer.available();
        if (avail < 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received message total length ({}) below minimum ({})", (Object)avail, (Object)4);
            }
            return;
        }
        int rpos = this.buffer.rpos();
        int len2 = this.buffer.getInt();
        if (len2 < 0) {
            throw new StreamCorruptedException("Illogical message length: " + len2);
        }
        this.buffer.rpos(rpos);
        avail = this.buffer.available();
        if (avail < len2 + 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received request length ({}) below minimum ({})", (Object)avail, (Object)(len2 + 4));
            }
            return;
        }
        ByteArrayBuffer rep2 = new ByteArrayBuffer();
        ((Buffer)rep2).putUInt(0L);
        ((Buffer)rep2).rpos(((Buffer)rep2).wpos());
        ByteArrayBuffer req = new ByteArrayBuffer(this.buffer.getBytes());
        int cmd = -1;
        try {
            cmd = req.getUByte();
            this.process(cmd, req, rep2);
        }
        catch (Exception e2) {
            this.debug("Failed ({}) to handle command={}: {}", e2.getClass().getSimpleName(), cmd, e2.getMessage(), e2);
            rep2.clear();
            ((Buffer)rep2).putUInt(0L);
            ((Buffer)rep2).rpos(((Buffer)rep2).wpos());
            ((Buffer)rep2).putUInt(1L);
            ((Buffer)rep2).putByte((byte)30);
        }
        this.reply(this.prepare(rep2));
    }

    /*
     * WARNING - void declaration
     */
    protected void process(int cmd, Buffer req, Buffer rep2) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("process(cmd={})", (Object)SshAgentConstants.getCommandMessageName(cmd));
        }
        switch (cmd) {
            case 11: {
                LinkedList keys2;
                Iterable<? extends Map.Entry<PublicKey, String>> ids = this.agent.getIdentities();
                if (ids instanceof Collection) {
                    Collection keys22 = (Collection)ids;
                } else {
                    LinkedList c2 = new LinkedList();
                    for (Map.Entry<PublicKey, String> entry : ids) {
                        c2.add(entry);
                    }
                    keys2 = c2;
                }
                rep2.putByte((byte)12);
                rep2.putUInt(keys2.size());
                for (Map.Entry key2 : keys2) {
                    rep2.putPublicKey((PublicKey)key2.getKey());
                    rep2.putString((String)key2.getValue());
                }
                break;
            }
            case 13: {
                void var9_20;
                String keyType;
                PublicKey signingKey = req.getPublicKey();
                byte[] data2 = req.getBytes();
                int flags = req.getInt();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_SIGN_REQUEST key={}, flags=0x{}, data={}", signingKey.getAlgorithm(), Integer.toHexString(flags), BufferUtils.toHex(':', data2));
                }
                String string = keyType = ValidateUtils.checkNotNullAndNotEmpty(KeyUtils.getKeyType(signingKey), "Cannot resolve key type of %s", (Object)signingKey.getClass().getSimpleName());
                if ("ssh-rsa".equals(keyType)) {
                    switch (flags) {
                        case 4: {
                            String string2 = "rsa-sha2-512";
                            break;
                        }
                        case 2: {
                            String string3 = "rsa-sha2-256";
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("SSH2_AGENTC_SIGN_REQUEST: Unknown flag value 0x" + Integer.toHexString(flags) + ", only 0, 2, or 4 are allowed.");
                        }
                    }
                }
                Map.Entry<String, byte[]> result2 = this.agent.sign(null, signingKey, (String)var9_20, data2);
                String algo = result2.getKey();
                byte[] signature = result2.getValue();
                ByteArrayBuffer sig = new ByteArrayBuffer(algo.length() + signature.length + 64, false);
                sig.putString(algo);
                sig.putBytes(signature);
                rep2.putByte((byte)14);
                rep2.putBytes(((Buffer)sig).array(), ((Buffer)sig).rpos(), sig.available());
                break;
            }
            case 17: {
                KeyPair keyToAdd = req.getKeyPair();
                String comment = req.getString();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_ADD_IDENTITY comment={}", (Object)comment);
                }
                this.agent.addIdentity(keyToAdd, comment, new SshAgentKeyConstraint[0]);
                rep2.putByte((byte)6);
                break;
            }
            case 18: {
                PublicKey keyToRemove = req.getPublicKey();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_REMOVE_IDENTITY {}", (Object)keyToRemove.getClass().getSimpleName());
                }
                this.agent.removeIdentity(keyToRemove);
                rep2.putByte((byte)6);
                break;
            }
            case 19: {
                this.agent.removeAllIdentities();
                rep2.putByte((byte)6);
                break;
            }
            default: {
                if (debugEnabled) {
                    this.log.debug("Unknown command: {}", (Object)SshAgentConstants.getCommandMessageName(cmd));
                }
                rep2.putByte((byte)30);
            }
        }
    }

    protected Buffer prepare(Buffer buf) {
        int len2 = buf.available();
        int rpos = buf.rpos();
        int wpos = buf.wpos();
        buf.rpos(rpos - 4);
        buf.wpos(rpos - 4);
        buf.putUInt(len2);
        buf.wpos(wpos);
        return buf;
    }

    protected abstract void reply(Buffer var1) throws IOException;
}

