/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class DefaultAgentForwardSupport
extends AbstractCloseable
implements AgentForwardSupport {
    private final ConnectionService serviceInstance;
    private final AtomicReference<SshAgentServer> agentServerHolder = new AtomicReference();

    public DefaultAgentForwardSupport(ConnectionService service) {
        this.serviceInstance = Objects.requireNonNull(service, "No connection service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String initialize() throws IOException {
        Object session2 = this.serviceInstance.getSession();
        try {
            SshAgentServer agentServer;
            AtomicReference<SshAgentServer> atomicReference = this.agentServerHolder;
            synchronized (atomicReference) {
                agentServer = this.agentServerHolder.get();
                if (agentServer != null) {
                    return agentServer.getId();
                }
                agentServer = Objects.requireNonNull(this.createSshAgentServer(this.serviceInstance, (Session)session2), "No agent server created");
                this.agentServerHolder.set(agentServer);
            }
            String agentId = agentServer.getId();
            if (this.log.isDebugEnabled()) {
                this.log.debug("initialize({}) id={}, server={}", session2, agentId, agentServer);
            }
            return agentId;
        }
        catch (Throwable t2) {
            this.error("initialize({}) failed ({}) to create server: {}", session2, t2.getClass().getSimpleName(), t2.getMessage(), t2);
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new SshException(t2);
        }
    }

    protected SshAgentServer createSshAgentServer(ConnectionService service, Session session2) throws Throwable {
        FactoryManager manager = Objects.requireNonNull(session2.getFactoryManager(), "No session factory manager");
        SshAgentFactory factory2 = Objects.requireNonNull(manager.getAgentFactory(), "No agent factory");
        return factory2.createServer(service);
    }

    @Override
    public void close() throws IOException {
        SshAgentServer agentServer = this.agentServerHolder.getAndSet(null);
        if (agentServer != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("close({}) closing server={}", this.serviceInstance.getSession(), (Object)agentServer);
            }
            agentServer.close();
        }
    }

    @Override
    protected void doCloseImmediately() {
        try {
            this.close();
        }
        catch (IOException e2) {
            throw new UncheckedIOException("Failed (" + e2.getClass().getSimpleName() + ") to close agent: " + e2.getMessage(), e2);
        }
        super.doCloseImmediately();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.serviceInstance.getSession() + "]";
    }
}

