/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentImpl
implements SshAgent {
    private static final Logger LOG = LoggerFactory.getLogger(AgentImpl.class);
    private final List<Map.Entry<KeyPair, String>> keys = new ArrayList<Map.Entry<KeyPair, String>>();
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public Iterable<? extends Map.Entry<PublicKey, String>> getIdentities() throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        return GenericUtils.map(this.keys, kp -> new AbstractMap.SimpleImmutableEntry<PublicKey, String>(((KeyPair)kp.getKey()).getPublic(), (String)kp.getValue()));
    }

    @Override
    public Map.Entry<String, byte[]> sign(SessionContext session2, PublicKey key2, String algo, byte[] data2) throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        try {
            Signature verif;
            Map.Entry<KeyPair, String> pp = Objects.requireNonNull(AgentImpl.getKeyPair(this.keys, key2), "Key not found");
            String agentName = pp.getValue();
            KeyPair kp = ValidateUtils.checkNotNull(pp.getKey(), "No key pair for agent=%s", (Object)agentName);
            PublicKey pubKey = ValidateUtils.checkNotNull(kp.getPublic(), "No public key for agent=%s", (Object)agentName);
            NamedFactory<Signature> factory2 = SignatureFactory.resolveSignatureFactoryByPublicKey(pubKey, algo);
            Signature signature = verif = factory2 == null ? null : (Signature)factory2.create();
            if (verif == null) {
                throw new InvalidKeySpecException("No signer found for " + pubKey.getClass().getSimpleName() + " when algorithm=" + algo + " requested for " + KeyUtils.getKeyType(pubKey));
            }
            verif.initSigner(session2, kp.getPrivate());
            verif.update(session2, data2);
            byte[] signature2 = verif.sign(session2);
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(factory2.getName(), signature2);
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new SshException(e3);
        }
    }

    @Override
    public void addIdentity(KeyPair key2, String comment, SshAgentKeyConstraint ... constraints) throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        if (!GenericUtils.isEmpty(constraints) && LOG.isDebugEnabled()) {
            LOG.debug("addIdentity({})[{}] {}: local agent does not implement key constraints; ignoring", KeyUtils.getKeyType(key2), comment, KeyUtils.getFingerPrint(key2.getPublic()));
        }
        this.keys.add(new AbstractMap.SimpleImmutableEntry<KeyPair, String>(Objects.requireNonNull(key2, "No key"), comment));
    }

    @Override
    public KeyPair resolveLocalIdentity(PublicKey key2) {
        Map.Entry<KeyPair, String> pp = AgentImpl.getKeyPair(this.keys, key2);
        return pp == null ? null : pp.getKey();
    }

    @Override
    public void removeIdentity(PublicKey key2) throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        Map.Entry<KeyPair, String> kp = AgentImpl.getKeyPair(this.keys, key2);
        if (kp == null) {
            throw new SshException("Key not found");
        }
        this.keys.remove(kp);
    }

    @Override
    public void removeAllIdentities() throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        this.keys.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.keys.clear();
        }
    }

    protected static Map.Entry<KeyPair, String> getKeyPair(Collection<? extends Map.Entry<KeyPair, String>> keys2, PublicKey key2) {
        if (GenericUtils.isEmpty(keys2) || key2 == null) {
            return null;
        }
        for (Map.Entry<KeyPair, String> entry : keys2) {
            KeyPair kp = entry.getKey();
            if (!KeyUtils.compareKeys(key2, kp.getPublic())) continue;
            return entry;
        }
        return null;
    }
}

