/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.local.AgentForwardedChannel;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;

public class AgentServerProxy
extends AbstractLoggingBean
implements SshAgentServer {
    private final ConnectionService service;
    private final String id;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public AgentServerProxy(ConnectionService service) throws IOException {
        this.service = Objects.requireNonNull(service, "No connection service provided");
        this.id = UUID.randomUUID().toString();
    }

    public SshAgent createClient() throws IOException {
        try {
            Object session2 = this.service.getSession();
            String channelType = CoreModuleProperties.PROXY_CHANNEL_TYPE.getRequired((PropertyResolver)session2);
            AgentForwardedChannel channel2 = new AgentForwardedChannel(channelType);
            this.service.registerChannel(channel2);
            channel2.open().verify(CoreModuleProperties.CHANNEL_OPEN_TIMEOUT.getRequired(channel2));
            return channel2.getAgent();
        }
        catch (Throwable t2) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("createClient({})[{}] failed to create client: {}", this.service.getSession(), this.getId(), t2.toString());
            }
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to create client: " + t2.getMessage(), t2);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false) && this.log.isDebugEnabled()) {
            this.log.debug("closed({})[{}]", this.service.getSession(), (Object)this.getId());
        }
    }
}

