/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.channel.AbstractServerChannel;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private OutputStream out;
    private SshAgent agent;
    private AgentClient client;

    public ChannelAgentForwarding(CloseableExecutorService executor) {
        super("", Collections.emptyList(), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f2 = new DefaultOpenFuture(this, this);
        String changeEvent = "auth-agent";
        try {
            this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            Session session2 = this.getSession();
            FactoryManager manager = Objects.requireNonNull(session2.getFactoryManager(), "No factory manager");
            SshAgentFactory factory2 = Objects.requireNonNull(manager.getAgentFactory(), "No agent factory");
            this.agent = factory2.createClient(session2, manager);
            this.client = new AgentClient();
            this.signalChannelOpenSuccess();
            f2.setOpened();
        }
        catch (Throwable t2) {
            Throwable e2 = ExceptionUtils.peelException(t2);
            changeEvent = e2.getClass().getSimpleName();
            this.signalChannelOpenFailure(e2);
            f2.setException(e2);
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
        return f2;
    }

    @Override
    public void handleEof() throws IOException {
        try {
            if (this.agent != null && this.agent.isOpen()) {
                this.agent.close();
            }
        }
        finally {
            super.handleEof();
        }
    }

    private void closeImmediately0() {
        try {
            if (this.agent != null && this.agent.isOpen()) {
                try {
                    this.agent.close();
                }
                catch (IOException e2) {
                    this.log.error("closeImmediately0({}) Failed ({}) to close open local agent: {}", this, e2.getClass().getSimpleName(), e2.getMessage());
                }
            }
        }
        finally {
            super.close(true);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    @Override
    protected void doWriteData(byte[] data2, int off, long len2) throws IOException {
        ValidateUtils.checkTrue(len2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len2);
        this.client.messageReceived(new ByteArrayBuffer(data2, off, (int)len2));
    }

    @Override
    protected void doWriteExtendedData(byte[] data2, int off, long len2) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    protected class AgentClient
    extends AbstractAgentClient {
        public AgentClient() {
            super(ChannelAgentForwarding.this.agent);
        }

        @Override
        protected void reply(Buffer buf) throws IOException {
            ChannelAgentForwarding.this.out.write(buf.array(), buf.rpos(), buf.available());
            ChannelAgentForwarding.this.out.flush();
        }
    }
}

