/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentServer
extends AbstractLoggingBean
implements Closeable,
ExecutorServiceCarrier {
    private final SshAgent agent;
    private final CloseableExecutorService service;
    private Future<?> agentThread;
    private String authSocket;
    private long pool;
    private long handle;

    public AgentServer() {
        this((CloseableExecutorService)null);
    }

    public AgentServer(CloseableExecutorService executor) {
        this(new AgentImpl(), executor);
    }

    public AgentServer(SshAgent agent, CloseableExecutorService executor) {
        this.agent = agent;
        this.service = executor == null ? ThreadUtils.newSingleThreadExecutor("AgentServer[" + agent + "]") : executor;
    }

    public SshAgent getAgent() {
        return this.agent;
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.service;
    }

    public String start() throws Exception {
        this.authSocket = AprLibrary.createLocalSocketAddress();
        this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
        this.handle = Local.create((String)this.authSocket, (long)this.pool);
        int result2 = Local.bind((long)this.handle, (long)0L);
        if (result2 != 0) {
            AgentServer.throwException(result2);
        }
        AprLibrary.secureLocalSocket(this.authSocket, this.handle);
        result2 = Local.listen((long)this.handle, (int)0);
        if (result2 != 0) {
            AgentServer.throwException(result2);
        }
        CloseableExecutorService executor = this.getExecutorService();
        this.agentThread = executor.submit(() -> {
            try {
                while (true) {
                    long clientSock = Local.accept((long)this.handle);
                    Socket.timeoutSet((long)clientSock, (long)10000000L);
                    new SshAgentSession(clientSock, this.agent).run();
                }
            }
            catch (Exception e2) {
                this.log.error("Failed to run session", e2);
                return;
            }
        });
        return this.authSocket;
    }

    @Override
    public void close() throws IOException {
        IOException err = null;
        try {
            this.agent.close();
        }
        catch (IOException e2) {
            err = e2;
        }
        Socket.close((long)this.handle);
        try {
            if (this.agentThread != null && !this.agentThread.isDone()) {
                this.agentThread.cancel(true);
            }
        }
        finally {
            this.agentThread = null;
        }
        CloseableExecutorService executor = this.getExecutorService();
        if (executor != null && !executor.isShutdown()) {
            List<Runnable> runners = executor.shutdownNow();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Shut down runners count={}", (Object)GenericUtils.size(runners));
            }
        }
        if (err != null) {
            throw err;
        }
    }

    private static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }

    protected static class SshAgentSession
    extends AbstractAgentClient
    implements Runnable {
        private final long socket;

        public SshAgentSession(long socket, SshAgent agent) {
            super(agent);
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                int result2;
                byte[] buf = new byte[1024];
                while ((result2 = Socket.recv((long)this.socket, (byte[])buf, (int)0, (int)buf.length)) != -70014) {
                    if (result2 < 0) {
                        AgentServer.throwException(result2);
                    }
                    this.messageReceived(new ByteArrayBuffer(buf, 0, result2));
                }
            }
            catch (Exception e2) {
                this.log.error("Failed to process", e2);
            }
            finally {
                Socket.close((long)this.socket);
            }
        }

        @Override
        protected void reply(Buffer buf) throws IOException {
            int result2 = Socket.send((long)this.socket, (byte[])buf.array(), (int)buf.rpos(), (int)buf.available());
            if (result2 < 0) {
                AgentServer.throwException(result2);
            }
        }
    }
}

