/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private String authSocket;
    private long pool;
    private long handle;
    private OutputStream out;
    private CloseableExecutorService forwardService;
    private Future<?> forwarder;

    public ChannelAgentForwarding(CloseableExecutorService executor) {
        super("", Collections.emptyList(), executor);
    }

    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f2 = new DefaultOpenFuture(this, this);
        try {
            CloseableExecutorService service;
            this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            this.authSocket = this.getString("SSH_AUTH_SOCK");
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)this.authSocket, (long)this.pool);
            int result2 = Local.connect((long)this.handle, (long)0L);
            if (result2 != 0) {
                ChannelAgentForwarding.throwException(result2);
            }
            this.forwardService = (service = this.getExecutorService()) == null ? ThreadUtils.newSingleThreadExecutor("ChannelAgentForwarding[" + this.authSocket + "]") : ThreadUtils.noClose(service);
            int copyBufSize = CoreModuleProperties.FORWARDER_BUFFER_SIZE.getRequired(this);
            ValidateUtils.checkTrue(copyBufSize >= 127, "Copy buf size below min.: %d", copyBufSize);
            ValidateUtils.checkTrue(copyBufSize <= Short.MAX_VALUE, "Copy buf size above max.: %d", copyBufSize);
            this.forwarder = this.forwardService.submit(() -> {
                try {
                    byte[] buf = new byte[copyBufSize];
                    while (true) {
                        int len2;
                        if ((len2 = Socket.recv((long)this.handle, (byte[])buf, (int)0, (int)buf.length)) <= 0) {
                            continue;
                        }
                        this.out.write(buf, 0, len2);
                        this.out.flush();
                    }
                }
                catch (IOException e2) {
                    this.close(true);
                    return;
                }
            });
            this.signalChannelOpenSuccess();
            f2.setOpened();
        }
        catch (Throwable t2) {
            Throwable e2 = ExceptionUtils.peelException(t2);
            this.signalChannelOpenFailure(e2);
            f2.setException(e2);
        }
        return f2;
    }

    private void closeImmediately0() {
        super.close(true);
        Socket.close((long)this.handle);
        try {
            if (this.forwarder != null && !this.forwarder.isDone()) {
                this.forwarder.cancel(true);
            }
        }
        finally {
            this.forwarder = null;
        }
        try {
            if (this.forwardService != null) {
                List<Runnable> runners = this.forwardService.shutdownNow();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Shut down runners count={}", (Object)GenericUtils.size(runners));
                }
            }
        }
        finally {
            this.forwardService = null;
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    @Override
    protected void doWriteData(byte[] data2, int off, long len2) throws IOException {
        ValidateUtils.checkTrue(len2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len2);
        int result2 = Socket.send((long)this.handle, (byte[])data2, (int)off, (int)((int)len2));
        if (result2 < 0) {
            ChannelAgentForwarding.throwException(result2);
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data2, int off, long len2) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    private static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

