/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.channels.Channel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.keys.ClientIdentity;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.DefaultClientIdentitiesWatcher;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientConnectionServiceFactory;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientUserAuthServiceFactory;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import org.apache.sshd.client.simple.AbstractSimpleClientSessionCreator;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderManager;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.Cancellable;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.MultiKeyIdentityProvider;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.functors.UnaryEquator;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager {
    public static final Factory<SshClient> DEFAULT_SSH_CLIENT_FACTORY = SshClient::new;
    public static final List<UserAuthFactory> DEFAULT_USER_AUTH_FACTORIES = Collections.unmodifiableList(Arrays.asList(UserAuthPublicKeyFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE, UserAuthPasswordFactory.INSTANCE));
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ClientUserAuthServiceFactory.INSTANCE, ClientConnectionServiceFactory.INSTANCE));
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected List<UserAuthFactory> userAuthFactories;
    private ClientProxyConnector proxyConnector;
    private ServerKeyVerifier serverKeyVerifier;
    private HostConfigEntryResolver hostConfigEntryResolver;
    private ClientIdentityLoader clientIdentityLoader;
    private KeyIdentityProvider keyIdentityProvider;
    private PublicKeyAuthenticationReporter publicKeyAuthenticationReporter;
    private FilePasswordProvider filePasswordProvider;
    private PasswordIdentityProvider passwordIdentityProvider;
    private PasswordAuthenticationReporter passwordAuthenticationReporter;
    private HostBasedAuthenticationReporter hostBasedAuthenticationReporter;
    private UserInteraction userInteraction;
    private final List<Object> identities = new CopyOnWriteArrayList<Object>();
    private final AuthenticationIdentitiesProvider identitiesProvider;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public SshClient() {
        this.identitiesProvider = AuthenticationIdentitiesProvider.wrapIdentities(this.identities);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        return this.proxyConnector;
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector proxyConnector) {
        this.proxyConnector = proxyConnector;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = Objects.requireNonNull(serverKeyVerifier, "No server key verifier");
    }

    @Override
    public HostConfigEntryResolver getHostConfigEntryResolver() {
        return this.hostConfigEntryResolver;
    }

    @Override
    public void setHostConfigEntryResolver(HostConfigEntryResolver resolver) {
        this.hostConfigEntryResolver = Objects.requireNonNull(resolver, "No host configuration entry resolver");
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.filePasswordProvider;
    }

    @Override
    public void setFilePasswordProvider(FilePasswordProvider provider2) {
        this.filePasswordProvider = Objects.requireNonNull(provider2, "No file password provider");
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.clientIdentityLoader;
    }

    @Override
    public void setClientIdentityLoader(ClientIdentityLoader loader) {
        this.clientIdentityLoader = Objects.requireNonNull(loader, "No client identity loader");
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public PasswordAuthenticationReporter getPasswordAuthenticationReporter() {
        return this.passwordAuthenticationReporter;
    }

    @Override
    public void setPasswordAuthenticationReporter(PasswordAuthenticationReporter reporter) {
        this.passwordAuthenticationReporter = reporter;
    }

    @Override
    public HostBasedAuthenticationReporter getHostBasedAuthenticationReporter() {
        return this.hostBasedAuthenticationReporter;
    }

    @Override
    public void setHostBasedAuthenticationReporter(HostBasedAuthenticationReporter reporter) {
        this.hostBasedAuthenticationReporter = reporter;
    }

    @Override
    public List<UserAuthFactory> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    @Override
    public void setUserAuthFactories(List<UserAuthFactory> userAuthFactories) {
        this.userAuthFactories = ValidateUtils.checkNotNullAndNotEmpty(userAuthFactories, "No user auth factories", new Object[0]);
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        return this.passwordIdentityProvider;
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider provider2) {
        this.passwordIdentityProvider = provider2;
    }

    @Override
    public void addPasswordIdentity(String password) {
        ValidateUtils.checkTrue(password != null && !password.isEmpty(), "No password provided");
        this.identities.add(password);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(password));
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        Objects.requireNonNull(kp, "No key-pair to add");
        Objects.requireNonNull(kp.getPublic(), "No public key");
        Objects.requireNonNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPublicKeyIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(kp.getPublic()));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public KeyIdentityProvider getKeyIdentityProvider() {
        return this.keyIdentityProvider;
    }

    @Override
    public void setKeyIdentityProvider(KeyIdentityProvider keyIdentityProvider) {
        this.keyIdentityProvider = keyIdentityProvider;
    }

    @Override
    public PublicKeyAuthenticationReporter getPublicKeyAuthenticationReporter() {
        return this.publicKeyAuthenticationReporter;
    }

    @Override
    public void setPublicKeyAuthenticationReporter(PublicKeyAuthenticationReporter reporter) {
        this.publicKeyAuthenticationReporter = reporter;
    }

    @Override
    protected void checkConfig() {
        List<ChannelFactory> forwarders;
        SshAgentFactory agentFactory;
        super.checkConfig();
        Objects.requireNonNull(this.getForwarderFactory(), "ForwarderFactory not set");
        Objects.requireNonNull(this.getServerKeyVerifier(), "ServerKeyVerifier not set");
        Objects.requireNonNull(this.getHostConfigEntryResolver(), "HostConfigEntryResolver not set");
        Objects.requireNonNull(this.getClientIdentityLoader(), "ClientIdentityLoader not set");
        Objects.requireNonNull(this.getFilePasswordProvider(), "FilePasswordProvider not set");
        KeyIdentityProvider defaultIdentities = this.getKeyIdentityProvider();
        if (defaultIdentities == null) {
            DefaultClientIdentitiesWatcher idsWatcher = new DefaultClientIdentitiesWatcher(this::getClientIdentityLoader, this::getFilePasswordProvider);
            this.setKeyIdentityProvider(idsWatcher);
        }
        if ((agentFactory = this.getAgentFactory()) != null && !GenericUtils.isEmpty(forwarders = agentFactory.getChannelForwardingFactories(this))) {
            List<? extends ChannelFactory> factories = this.getChannelFactories();
            if (GenericUtils.isEmpty(factories)) {
                factories = forwarders;
            } else {
                ArrayList<? extends ChannelFactory> factories2 = new ArrayList<ChannelFactory>(factories.size() + forwarders.size());
                factories2.addAll(factories);
                factories2.addAll(forwarders);
                factories = factories2;
            }
            this.setChannelFactories(factories);
        }
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
        if (GenericUtils.isEmpty(this.getUserAuthFactories())) {
            this.setUserAuthFactories(DEFAULT_USER_AUTH_FACTORIES);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() {
        if (this.isClosed()) {
            throw new IllegalStateException("Can not start the client again");
        }
        if (this.isStarted()) {
            return;
        }
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.setupSessionTimeout(this.sessionFactory);
        this.connector = this.createConnector();
        this.started.set(true);
    }

    public void stop() {
        if (!this.started.getAndSet(false)) {
            return;
        }
        try {
            Duration maxWait = CoreModuleProperties.STOP_WAIT_TIME.getRequired(this);
            boolean successful = this.close(true).await(maxWait);
            if (!successful) {
                throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
            }
        }
        catch (IOException e2) {
            this.warn("{} while stopping client: {}", e2.getClass().getSimpleName(), e2.getMessage(), e2);
        }
        finally {
            this.clearAttributes();
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        String closeId = this.toString();
        return this.builder().run(closeId, () -> this.removeSessionTimeout(this.sessionFactory)).sequential(this.connector, this.ioServiceFactory).run(closeId, () -> {
            this.connector = null;
            this.ioServiceFactory = null;
            if (this.shutdownExecutor && this.executor != null && !this.executor.isShutdown()) {
                try {
                    this.executor.shutdownNow();
                }
                finally {
                    this.executor = null;
                }
            }
        }).build();
    }

    @Override
    public ConnectFuture connect(String uriStr) throws IOException {
        Objects.requireNonNull(uriStr, "No uri address");
        URI uri2 = URI.create(uriStr.contains("//") ? uriStr : "ssh://" + uriStr);
        if (GenericUtils.isNotEmpty(uri2.getScheme()) && !"ssh".equals(uri2.getScheme())) {
            throw new IllegalArgumentException("Unsupported scheme for uri: " + uri2);
        }
        String host2 = uri2.getHost();
        int port2 = uri2.getPort();
        String userInfo = uri2.getUserInfo();
        return this.connect(userInfo, host2, port2);
    }

    @Override
    public ConnectFuture connect(String username, SocketAddress targetAddress, AttributeRepository context, SocketAddress localAddress2) throws IOException {
        Objects.requireNonNull(targetAddress, "No target address");
        if (!(targetAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetAddress = (InetSocketAddress)targetAddress;
        String host2 = ValidateUtils.checkNotNullAndNotEmpty(inetAddress.getHostString(), "No host");
        int port2 = inetAddress.getPort();
        ValidateUtils.checkTrue(port2 > 0, "Invalid port: %d", port2);
        return this.connect(username, host2, port2, context, localAddress2);
    }

    @Override
    public ConnectFuture connect(String username, String host2, int port2, AttributeRepository context, SocketAddress localAddress2) throws IOException {
        HostConfigEntry entry = this.resolveHost(username, host2, port2, context, localAddress2);
        return this.connect(entry, context, localAddress2);
    }

    @Override
    public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context, SocketAddress localAddress2) throws IOException {
        List<HostConfigEntry> jumps = this.parseProxyJumps(hostConfig, context);
        return this.doConnect(hostConfig, jumps, context, localAddress2);
    }

    protected ConnectFuture doConnect(HostConfigEntry hostConfig, List<HostConfigEntry> jumps, AttributeRepository context, SocketAddress localAddress2) throws IOException {
        Objects.requireNonNull(hostConfig, "No host configuration");
        String host2 = ValidateUtils.checkNotNullAndNotEmpty(hostConfig.getHostName(), "No target host");
        int port2 = hostConfig.getPort();
        ValidateUtils.checkTrue(port2 > 0, "Invalid port: %d", port2);
        Collection<String> hostIds = hostConfig.getIdentities();
        Collection idFiles = GenericUtils.stream(hostIds).map(x$0 -> Paths.get(x$0, new String[0])).map(PathResource::new).collect(Collectors.toCollection(() -> new ArrayList(hostIds.size())));
        KeyIdentityProvider keys2 = this.preloadClientIdentities(idFiles);
        String username = hostConfig.getUsername();
        InetSocketAddress targetAddress = new InetSocketAddress(hostConfig.getHostName(), hostConfig.getPort());
        if (GenericUtils.isNotEmpty(jumps)) {
            DefaultConnectFuture connectFuture = new DefaultConnectFuture(username + "@" + targetAddress, null);
            HostConfigEntry jump = jumps.remove(0);
            ConnectFuture f1 = this.doConnect(jump, jumps, context, null);
            AtomicReference<ConnectFuture> toCancel = new AtomicReference<ConnectFuture>(f1);
            connectFuture.addListener(c2 -> {
                if (!c2.isCanceled()) {
                    return;
                }
                Cancellable inner = (Cancellable)toCancel.get();
                if (inner == null) {
                    return;
                }
                CancelFuture cancellation = inner.cancel();
                if (cancellation == null) {
                    return;
                }
                cancellation.addListener(cf -> {
                    if (cf.isDone()) {
                        c2.getCancellation().setCanceled();
                    }
                });
            });
            f1.addListener(f2 -> {
                if (f2.isConnected()) {
                    ClientSession proxySession = f2.getClientSession();
                    try {
                        if (connectFuture.isCanceled()) {
                            proxySession.close(true);
                        }
                        AuthFuture auth = proxySession.auth();
                        toCancel.set((ConnectFuture)((Object)auth));
                        auth.addListener(f3 -> {
                            if (f3.isSuccess()) {
                                try {
                                    SshdSocketAddress address = new SshdSocketAddress(hostConfig.getHostName(), hostConfig.getPort());
                                    ExplicitPortForwardingTracker tracker = proxySession.createLocalPortForwardingTracker(SshdSocketAddress.LOCALHOST_ADDRESS, address);
                                    SshdSocketAddress bound = tracker.getBoundAddress();
                                    ConnectFuture f4 = this.doConnect(hostConfig.getUsername(), bound.toInetSocketAddress(), context, localAddress2, keys2, hostConfig);
                                    toCancel.set(f4);
                                    if (connectFuture.isCanceled()) {
                                        f4.cancel();
                                    }
                                    f4.addListener(f5 -> {
                                        if (f5.isConnected()) {
                                            ClientSession clientSession = f5.getClientSession();
                                            clientSession.setAttribute(TARGET_SERVER, address);
                                            connectFuture.setSession(clientSession);
                                            proxySession.addCloseFutureListener(f6 -> clientSession.close(true));
                                            clientSession.addCloseFutureListener(f6 -> proxySession.close(true));
                                        } else {
                                            proxySession.close(true);
                                            connectFuture.setException(f5.getException());
                                        }
                                    });
                                }
                                catch (IOException e2) {
                                    proxySession.close(true);
                                    connectFuture.setException(e2);
                                }
                            } else {
                                proxySession.close(true);
                                connectFuture.setException(f3.getException());
                            }
                        });
                    }
                    catch (IOException e2) {
                        proxySession.close(true);
                        connectFuture.setException(e2);
                    }
                } else {
                    connectFuture.setException(f2.getException());
                }
            });
            return connectFuture;
        }
        return this.doConnect(hostConfig.getUsername(), new InetSocketAddress(host2, port2), context, localAddress2, keys2, hostConfig);
    }

    protected ConnectFuture doConnect(String username, SocketAddress targetAddress, AttributeRepository context, SocketAddress localAddress2, KeyIdentityProvider identities, HostConfigEntry hostConfig) throws IOException {
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        DefaultConnectFuture connectFuture = new DefaultConnectFuture(username + "@" + targetAddress, null);
        SshFutureListener<IoConnectFuture> listener = this.createConnectCompletionListener(connectFuture, username, targetAddress, identities, hostConfig);
        IoConnectFuture connectingFuture = this.connector.connect(targetAddress, context, localAddress2);
        connectFuture.addListener(c2 -> {
            if (c2.isCanceled()) {
                connectingFuture.cancel();
            }
        });
        connectingFuture.addListener(listener);
        return connectFuture;
    }

    /*
     * Exception decompiling
     */
    protected List<HostConfigEntry> parseProxyJumps(HostConfigEntry entry, AttributeRepository context) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 6[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<HostConfigEntry> parseProxyJumps(String proxyJump, AttributeRepository context) throws IOException {
        String[] hops;
        ArrayList<HostConfigEntry> jumps = new ArrayList<HostConfigEntry>();
        if (GenericUtils.isEmpty(proxyJump)) {
            return jumps;
        }
        for (String hop : hops = GenericUtils.split(proxyJump, ',')) {
            String h2 = hop.trim();
            if (h2.isEmpty()) {
                throw new IllegalArgumentException("Empty proxy jump in list: " + proxyJump);
            }
            URI uri2 = URI.create(h2.contains("://") ? h2 : "ssh://" + h2);
            if (GenericUtils.isNotEmpty(uri2.getScheme()) && !"ssh".equals(uri2.getScheme())) {
                throw new IllegalArgumentException("Unsupported scheme for proxy jump: " + hop);
            }
            String host2 = uri2.getHost();
            int port2 = uri2.getPort();
            String userInfo = uri2.getUserInfo();
            HostConfigEntry entry = this.resolveHost(userInfo, host2, port2, context, null);
            jumps.add(entry);
        }
        return jumps;
    }

    protected HostConfigEntry resolveHost(String username, String host2, int port2, AttributeRepository context, SocketAddress localAddress2) throws IOException {
        HostConfigEntryResolver resolver = this.getHostConfigEntryResolver();
        HostConfigEntry entry = resolver.resolveEffectiveHost(host2, port2, localAddress2, username, null, context);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) no overrides", username, host2, port2);
            }
            entry = SshdSocketAddress.isIPv6Address(host2) ? new HostConfigEntry("", host2, port2, username, null) : new HostConfigEntry(host2, host2, port2, username, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}:{}) effective: {}", username, host2, port2, entry);
        }
        return entry;
    }

    protected KeyIdentityProvider preloadClientIdentities(Collection<? extends NamedResource> locations) throws IOException {
        return GenericUtils.isEmpty(locations) ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : ClientIdentityLoader.asKeyIdentityProvider(Objects.requireNonNull(this.getClientIdentityLoader(), "No ClientIdentityLoader"), locations, this.getFilePasswordProvider(), CoreModuleProperties.IGNORE_INVALID_IDENTITIES.getRequired(this));
    }

    protected SshFutureListener<IoConnectFuture> createConnectCompletionListener(final ConnectFuture connectFuture, final String username, final SocketAddress address, final KeyIdentityProvider identities, final HostConfigEntry hostConfig) {
        return new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    CancelFuture cancellation = connectFuture.cancel();
                    if (cancellation != null) {
                        future.getCancellation().addListener(f2 -> cancellation.setCanceled(f2.getBackTrace()));
                    }
                    return;
                }
                Throwable t2 = future.getException();
                if (t2 != null) {
                    if (SshClient.this.log.isDebugEnabled()) {
                        SshClient.this.log.debug("operationComplete({}@{}) failed ({}): {}", username, address, t2.getClass().getSimpleName(), t2.getMessage());
                    }
                    connectFuture.setException(t2);
                } else {
                    IoSession ioSession = future.getSession();
                    try {
                        SshClient.this.onConnectOperationComplete(ioSession, connectFuture, username, address, identities, hostConfig);
                    }
                    catch (IOException | RuntimeException | GeneralSecurityException e2) {
                        SshClient.this.warn("operationComplete({}@{}) failed ({}) to signal completion of session={}: {}", username, address, e2.getClass().getSimpleName(), ioSession, e2.getMessage(), e2);
                        connectFuture.setException(e2);
                        ioSession.close(true);
                    }
                }
            }

            public String toString() {
                return "ConnectCompletionListener[" + username + "@" + address + "]";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectOperationComplete(IoSession ioSession, ConnectFuture connectFuture, String username, SocketAddress address, KeyIdentityProvider identities, HostConfigEntry hostConfig) throws IOException, GeneralSecurityException {
        AbstractClientSession session2 = (AbstractClientSession)AbstractSession.getSession(ioSession);
        session2.setUsername(username);
        session2.setConnectAddress(address);
        boolean useDefaultIdentities = !hostConfig.isIdentitiesOnly();
        session2.setAttribute(UserAuthPublicKey.USE_DEFAULT_IDENTITIES, useDefaultIdentities);
        String identityAgent = hostConfig.getProperty("IdentityAgent");
        session2.setAttribute(UserAuthPublicKey.IDENTITY_AGENT, identityAgent == null ? "" : identityAgent);
        if (useDefaultIdentities) {
            this.setupDefaultSessionIdentities(session2, identities);
        } else if (identities == null) {
            session2.setKeyIdentityProvider(KeyIdentityProvider.EMPTY_KEYS_PROVIDER);
        } else {
            session2.setKeyIdentityProvider(this.ensureFilePasswordProvider(identities));
        }
        connectFuture.setSession(session2);
        if (session2 != connectFuture.getSession()) {
            try {
                session2.close(true);
            }
            finally {
                CancelFuture cancellation = connectFuture.cancel();
                if (cancellation != null) {
                    cancellation.setCanceled();
                }
            }
        }
    }

    protected KeyIdentityProvider ensureFilePasswordProvider(KeyIdentityProvider identities) {
        if (identities instanceof AbstractResourceKeyPairProvider) {
            FilePasswordProvider passwordProvider;
            AbstractResourceKeyPairProvider keyProvider = (AbstractResourceKeyPairProvider)identities;
            if (keyProvider.getPasswordFinder() == null && (passwordProvider = this.getFilePasswordProvider()) != null) {
                keyProvider.setPasswordFinder(passwordProvider);
            }
        } else if (identities instanceof FilePasswordProviderManager) {
            FilePasswordProvider passwordProvider;
            FilePasswordProviderManager keyProvider = (FilePasswordProviderManager)((Object)identities);
            if (keyProvider.getFilePasswordProvider() == null && (passwordProvider = this.getFilePasswordProvider()) != null) {
                keyProvider.setFilePasswordProvider(passwordProvider);
            }
        } else if (identities instanceof MultiKeyIdentityProvider) {
            MultiKeyIdentityProvider multiProvider = (MultiKeyIdentityProvider)identities;
            multiProvider.getProviders().forEach(this::ensureFilePasswordProvider);
        }
        return identities;
    }

    protected void setupDefaultSessionIdentities(ClientSession session2, KeyIdentityProvider extraIdentities) throws IOException, GeneralSecurityException {
        PasswordIdentityProvider passClient;
        PasswordIdentityProvider passSession;
        KeyIdentityProvider kpClient;
        boolean debugEnabled = this.log.isDebugEnabled();
        KeyIdentityProvider kpSession = session2.getKeyIdentityProvider();
        if (UnaryEquator.isSameReference(kpSession, kpClient = this.getKeyIdentityProvider()) && debugEnabled) {
            this.log.debug("setupDefaultSessionIdentities({}) key identity provider override in session listener", (Object)session2);
        }
        KeyIdentityProvider kpEffective = KeyIdentityProvider.resolveKeyIdentityProvider(extraIdentities, kpSession);
        if (!UnaryEquator.isSameReference(kpSession, kpEffective = this.ensureFilePasswordProvider(kpEffective))) {
            if (debugEnabled) {
                this.log.debug("setupDefaultSessionIdentities({}) key identity provider enhanced", (Object)session2);
            }
            session2.setKeyIdentityProvider(kpEffective);
        }
        if (!UnaryEquator.isSameReference(passSession = session2.getPasswordIdentityProvider(), passClient = this.getPasswordIdentityProvider()) && debugEnabled) {
            this.log.debug("setupDefaultSessionIdentities({}) password provider override", (Object)session2);
        }
        AuthenticationIdentitiesProvider idsClient = this.getRegisteredIdentities();
        boolean traceEnabled = this.log.isTraceEnabled();
        Iterator iter = GenericUtils.iteratorOf(idsClient == null ? null : idsClient.loadIdentities(session2));
        while (iter.hasNext()) {
            Object id = iter.next();
            if (id instanceof String) {
                if (traceEnabled) {
                    this.log.trace("setupDefaultSessionIdentities({}) add password fingerprint={}", (Object)session2, (Object)KeyUtils.getFingerPrint(id.toString()));
                }
                session2.addPasswordIdentity((String)id);
                continue;
            }
            if (id instanceof KeyPair) {
                KeyPair kp = (KeyPair)id;
                if (traceEnabled) {
                    this.log.trace("setupDefaultSessionIdentities({}) add identity type={}, fingerprint={}", session2, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic()));
                }
                session2.addPublicKeyIdentity(kp);
                continue;
            }
            if (!debugEnabled) continue;
            this.log.debug("setupDefaultSessionIdentities({}) ignored identity={}", (Object)session2, id);
        }
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SimpleClient setUpDefaultSimpleClient() {
        SshClient client2 = SshClient.setUpDefaultClient();
        client2.start();
        return SshClient.wrapAsSimpleClient(client2);
    }

    public static SimpleClient wrapAsSimpleClient(final SshClient client2) {
        Objects.requireNonNull(client2, "No client instance");
        Channel channel2 = new Channel(){

            @Override
            public boolean isOpen() {
                return client2.isOpen();
            }

            @Override
            public void close() throws IOException {
                Exception err = null;
                try {
                    client2.close();
                }
                catch (Exception e2) {
                    err = ExceptionUtils.accumulateException(err, e2);
                }
                try {
                    client2.stop();
                }
                catch (Exception e3) {
                    err = ExceptionUtils.accumulateException(err, e3);
                }
                if (err != null) {
                    if (err instanceof IOException) {
                        throw (IOException)err;
                    }
                    throw new IOException(err);
                }
            }
        };
        return AbstractSimpleClientSessionCreator.wrap(client2, channel2);
    }

    public static SshClient setUpDefaultClient() {
        ClientBuilder builder = ClientBuilder.builder();
        return (SshClient)builder.build();
    }

    public static <C extends SshClient> C setKeyPairProvider(C client2, boolean strict, boolean supportedOnly, FilePasswordProvider provider2, LinkOption ... options2) throws IOException, GeneralSecurityException {
        return SshClient.setKeyPairProvider(client2, PublicKeyEntry.getDefaultKeysFolderPath(), strict, supportedOnly, provider2, options2);
    }

    public static <C extends SshClient> C setKeyPairProvider(C client2, Path dir, boolean strict, boolean supportedOnly, FilePasswordProvider provider2, LinkOption ... options2) throws IOException, GeneralSecurityException {
        KeyPairProvider kpp = ClientIdentity.loadDefaultKeyPairProvider(dir, strict, supportedOnly, provider2, options2);
        if (kpp != null) {
            client2.setKeyIdentityProvider(kpp);
        }
        return client2;
    }
}

