/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.hostbased;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface HostKeyIdentityProvider {
    public Iterable<? extends Map.Entry<KeyPair, List<X509Certificate>>> loadHostKeys(SessionContext var1) throws IOException, GeneralSecurityException;

    public static Iterator<? extends Map.Entry<KeyPair, List<X509Certificate>>> iteratorOf(SessionContext session2, HostKeyIdentityProvider provider2) throws IOException, GeneralSecurityException {
        return GenericUtils.iteratorOf(provider2 == null ? null : provider2.loadHostKeys(session2));
    }

    public static HostKeyIdentityProvider wrap(KeyPair ... pairs2) {
        return HostKeyIdentityProvider.wrap(GenericUtils.asList(pairs2));
    }

    public static HostKeyIdentityProvider wrap(Iterable<KeyPair> pairs2) {
        return session2 -> GenericUtils.wrapIterable(pairs2, kp -> new AbstractMap.SimpleImmutableEntry((KeyPair)kp, Collections.emptyList()));
    }
}

