/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.hostbased;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.apache.sshd.client.auth.hostbased.HostKeyIdentityProvider;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class UserAuthHostBased
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "hostbased";
    protected Iterator<? extends Map.Entry<KeyPair, ? extends Collection<X509Certificate>>> keys;
    protected Map.Entry<KeyPair, ? extends Collection<X509Certificate>> keyInfo;
    protected final HostKeyIdentityProvider clientHostKeys;
    private List<NamedFactory<Signature>> factories;
    private String clientUsername;
    private String clientHostname;

    public UserAuthHostBased(HostKeyIdentityProvider clientHostKeys) {
        super(NAME);
        this.clientHostKeys = clientHostKeys;
    }

    @Override
    public void init(ClientSession session2, String service) throws Exception {
        super.init(session2, service);
        this.keys = HostKeyIdentityProvider.iteratorOf(session2, this.clientHostKeys);
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    public String getClientUsername() {
        return this.clientUsername;
    }

    public void setClientUsername(String clientUsername) {
        this.clientUsername = clientUsername;
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public void setClientHostname(String clientHostname) {
        this.clientHostname = clientHostname;
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session2, String service) throws Exception {
        String name = this.getName();
        boolean debugEnabled = this.log.isDebugEnabled();
        String clientUsername = this.resolveClientUsername(session2);
        String clientHostname = this.resolveClientHostname(session2);
        HostBasedAuthenticationReporter reporter = session2.getHostBasedAuthenticationReporter();
        Map.Entry<KeyPair, ? extends Collection<X509Certificate>> entry = this.keyInfo = this.keys != null && this.keys.hasNext() ? this.keys.next() : null;
        if (this.keyInfo == null) {
            if (debugEnabled) {
                this.log.debug("sendAuthDataRequest({})[{}][{}] no more keys to send", session2, service, name);
            }
            if (reporter != null) {
                reporter.signalAuthenticationExhausted(session2, service, clientUsername, clientHostname);
            }
            return false;
        }
        KeyPair kp = this.keyInfo.getKey();
        PublicKey pub = kp.getPublic();
        String keyType = KeyUtils.getKeyType(pub);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendAuthDataRequest({})[{}][{}] current key details: type={}, fingerprint={}", session2, service, name, keyType, KeyUtils.getFingerPrint(pub));
        }
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, session2), "No signature factories for session=%s", session2);
        Signature verifier = ValidateUtils.checkNotNull(NamedFactory.create(factories, keyType), "No signer could be located for key type=%s", (Object)keyType);
        byte[] id = session2.getSessionId();
        String username = session2.getUsername();
        if (debugEnabled) {
            this.log.debug("sendAuthDataRequest({})[{}][{}] client={}@{}", session2, service, name, clientUsername, clientHostname);
        }
        int length = id.length + username.length() + service.length() + clientUsername.length() + clientHostname.length() + keyType.length() + 256 + 64;
        Buffer buffer = session2.createBuffer((byte)50, length);
        buffer.clear();
        buffer.putRawPublicKey(pub);
        Collection<X509Certificate> certs = this.keyInfo.getValue();
        if (GenericUtils.size(certs) > 0) {
            for (X509Certificate c2 : certs) {
                buffer.putRawBytes(c2.getEncoded());
            }
        }
        verifier.initSigner(session2, kp.getPrivate());
        byte[] keyBytes = buffer.getCompactData();
        buffer = session2.prepareBuffer((byte)50, BufferUtils.clear(buffer));
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putString(keyType);
        buffer.putBytes(keyBytes);
        buffer.putString(clientHostname);
        buffer.putString(clientUsername);
        byte[] signature = this.appendSignature(session2, service, keyType, pub, keyBytes, clientHostname, clientUsername, verifier, buffer);
        if (reporter != null) {
            reporter.signalAuthenticationAttempt(session2, service, kp, clientHostname, clientUsername, signature);
        }
        session2.writePacket(buffer);
        return true;
    }

    protected byte[] appendSignature(ClientSession session2, String service, String keyType, PublicKey key2, byte[] keyBytes, String clientHostname, String clientUsername, Signature verifier, Buffer buffer) throws Exception {
        byte[] id = session2.getSessionId();
        String username = session2.getUsername();
        String name = this.getName();
        int length = id.length + username.length() + service.length() + name.length() + keyType.length() + keyBytes.length + clientHostname.length() + clientUsername.length() + 256 + 64;
        ByteArrayBuffer bs = new ByteArrayBuffer(length, false);
        bs.putBytes(id);
        ((Buffer)bs).putByte((byte)50);
        bs.putString(username);
        bs.putString(service);
        bs.putString(name);
        bs.putString(keyType);
        bs.putBytes(keyBytes);
        bs.putString(clientHostname);
        bs.putString(clientUsername);
        verifier.update(session2, ((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
        byte[] signature = verifier.sign(session2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}][{}] type={}, fingerprint={}, client={}@{}: signature={}", session2, service, name, keyType, KeyUtils.getFingerPrint(key2), clientUsername, clientHostname, BufferUtils.toHex(signature));
        }
        bs.clear();
        bs.putString(keyType);
        bs.putBytes(signature);
        buffer.putBytes(((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
        return signature;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session2, String service, Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        throw new IllegalStateException("processAuthDataRequest(" + session2 + ")[" + service + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession session2, String service, Buffer buffer) throws Exception {
        HostBasedAuthenticationReporter reporter = session2.getHostBasedAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationSuccess(session2, service, this.keyInfo == null ? null : this.keyInfo.getKey(), this.resolveClientHostname(session2), this.resolveClientUsername(session2));
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession session2, String service, boolean partial, List<String> serverMethods, Buffer buffer) throws Exception {
        HostBasedAuthenticationReporter reporter = session2.getHostBasedAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationFailure(session2, service, this.keyInfo == null ? null : this.keyInfo.getKey(), this.resolveClientHostname(session2), this.resolveClientUsername(session2), partial, serverMethods);
        }
    }

    protected String resolveClientUsername(ClientSession session2) {
        String value2 = this.getClientUsername();
        return GenericUtils.isEmpty(value2) ? OsUtils.getCurrentUser() : value2;
    }

    protected String resolveClientHostname(ClientSession session2) {
        String value2 = this.getClientHostname();
        if (GenericUtils.isEmpty(value2)) {
            value2 = SshdSocketAddress.toAddressString(SshdSocketAddress.getFirstExternalNetwork4Address());
        }
        return GenericUtils.isEmpty(value2) ? "127.0.0.1" : value2;
    }
}

