/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.keyboard;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String NAME = "keyboard-interactive";
    private final AtomicBoolean requestPending = new AtomicBoolean(false);
    private Iterator<String> passwords;
    private int maxAttempts;
    private int nOfAttempts;
    private boolean wasChallenged;
    private boolean withUserInteraction;

    public UserAuthKeyboardInteractive() {
        super(NAME);
    }

    @Override
    public void init(ClientSession session2, String service) throws Exception {
        super.init(session2, service);
        this.passwords = ClientSession.passwordIteratorOf(session2);
        this.maxAttempts = Math.max(1, CoreModuleProperties.PASSWORD_PROMPTS.getRequired(session2));
        this.nOfAttempts = 0;
        this.wasChallenged = false;
        this.withUserInteraction = false;
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session2, String service) throws Exception {
        String name = this.getName();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.requestPending.get()) {
            if (debugEnabled) {
                this.log.debug("sendAuthDataRequest({})[{}] no reply for previous request for {}", session2, service, name);
            }
            return false;
        }
        ++this.nOfAttempts;
        if (this.wasChallenged && !this.withUserInteraction) {
            --this.nOfAttempts;
        }
        this.wasChallenged = false;
        this.withUserInteraction = false;
        if (!this.verifyTrialsCount(session2, service, 50, this.nOfAttempts, this.maxAttempts)) {
            return false;
        }
        String username = session2.getUsername();
        String lang = this.getExchangeLanguageTag(session2);
        String subMethods = this.getExchangeSubMethods(session2);
        if (debugEnabled) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST for {}: lang={}, methods={}", session2, service, name, lang, subMethods);
        }
        int length = username.length() + service.length() + name.length() + GenericUtils.length(lang) + GenericUtils.length(subMethods) + 64;
        Buffer buffer = session2.createBuffer((byte)50, length);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putString(lang);
        buffer.putString(subMethods);
        this.requestPending.set(true);
        session2.writePacket(buffer);
        return true;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session2, String service, Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session2 + ")[" + service + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        this.requestPending.set(false);
        String name = buffer.getString();
        String instruction = buffer.getString();
        String lang = buffer.getString();
        int num = buffer.getInt();
        if (num < 0 || num > 32768) {
            this.log.error("processAuthDataRequest({})[{}] illogical challenges count ({}) for name={}, instruction={}", session2, service, num, name, instruction);
            throw new IndexOutOfBoundsException("Illogical challenges count: " + num);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}] SSH_MSG_USERAUTH_INFO_REQUEST name={}, instruction={}, language={}, num-prompts={}", session2, service, name, instruction, lang, num);
        }
        String[] prompt = num > 0 ? new String[num] : GenericUtils.EMPTY_STRING_ARRAY;
        boolean[] echo = num > 0 ? new boolean[num] : GenericUtils.EMPTY_BOOLEAN_ARRAY;
        boolean traceEnabled = this.log.isTraceEnabled();
        for (int i2 = 0; i2 < num; ++i2) {
            prompt[i2] = buffer.getString();
            echo[i2] = buffer.getBoolean();
            if (!traceEnabled) continue;
            this.log.trace("processAuthDataRequest({})[{}]({}) {}/{}: echo={}, prompt={}", session2, service, name, i2 + 1, num, echo[i2], prompt[i2]);
        }
        String[] rep2 = this.getUserResponses(name, instruction, lang, prompt, echo);
        if (rep2 == null) {
            if (debugEnabled) {
                this.log.debug("processAuthDataRequest({})[{}] no responses for {}", session2, service, name);
            }
            return false;
        }
        if (num != rep2.length) {
            this.log.warn("processAuthDataRequest({})[{}] Mismatched prompts ({}) vs. responses count ({})", session2, service, num, rep2.length);
        }
        int numResponses = rep2.length;
        buffer = session2.createBuffer((byte)61, numResponses * 64 + 8);
        buffer.putUInt(numResponses);
        for (int index = 0; index < numResponses; ++index) {
            String r = rep2[index];
            if (traceEnabled) {
                this.log.trace("processAuthDataRequest({})[{}] response #{}: {}", session2, service, index + 1, index < num && echo[index] ? r : "(hidden)");
            }
            buffer.putString(r);
        }
        session2.writePacket(buffer);
        return true;
    }

    protected String getExchangeLanguageTag(ClientSession session2) {
        return CoreModuleProperties.INTERACTIVE_LANGUAGE_TAG.getRequired(session2);
    }

    protected String getExchangeSubMethods(ClientSession session2) {
        return CoreModuleProperties.INTERACTIVE_SUBMETHODS.getRequired(session2);
    }

    protected String getCurrentPasswordCandidate() {
        if (this.passwords != null && this.passwords.hasNext()) {
            return this.passwords.next();
        }
        return null;
    }

    protected boolean verifyTrialsCount(ClientSession session2, String service, int cmd, int nbTrials, int maxAllowed) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("verifyTrialsCount({})[{}] cmd={} - {} out of {}", session2, service, UserAuthKeyboardInteractive.getAuthCommandName(cmd), nbTrials, maxAllowed);
        }
        return nbTrials <= maxAllowed;
    }

    protected String[] getUserResponses(String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        String candidate;
        ClientSession session2 = this.getClientSession();
        int num = GenericUtils.length(prompt);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (num == 0) {
            if (debugEnabled) {
                this.log.debug("getUserResponses({}) no prompts for interaction={}", (Object)session2, (Object)name);
            }
            return GenericUtils.EMPTY_STRING_ARRAY;
        }
        this.wasChallenged = true;
        if (PropertyResolverUtils.getBooleanProperty(session2, "user-interaction-auto-detect-password-prompt", true) && this.useCurrentPassword(session2, candidate = this.getCurrentPasswordCandidate(), name, instruction, lang, prompt, echo)) {
            if (debugEnabled) {
                this.log.debug("getUserResponses({}) use password candidate for interaction={}", (Object)session2, (Object)name);
            }
            return new String[]{candidate};
        }
        this.withUserInteraction = true;
        UserInteraction ui = session2.getUserInteraction();
        try {
            if (ui != null && ui.isInteractionAllowed(session2)) {
                return ui.interactive(session2, name, instruction, lang, prompt, echo);
            }
        }
        catch (Error e2) {
            this.warn("getUserResponses({}) failed ({}) to consult interaction: {}", session2, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            throw new RuntimeSshException(e2);
        }
        if (debugEnabled) {
            this.log.debug("getUserResponses({}) no user interaction for name={}", (Object)session2, (Object)name);
        }
        return null;
    }

    protected boolean useCurrentPassword(ClientSession session2, String password, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        String promptList;
        int num = GenericUtils.length(prompt);
        if (num != 1 || password == null || echo[0]) {
            return false;
        }
        String value2 = GenericUtils.trimToEmpty(prompt[0]);
        int passPos = UserInteraction.findPromptComponentLastPosition(value2 = value2.toLowerCase(), promptList = PropertyResolverUtils.getStringProperty(session2, "user-interaction-password-prompt", "password"));
        if (passPos < 0) {
            return false;
        }
        String delimList = PropertyResolverUtils.getStringProperty(session2, "user-interaction-check-password-delimiter", ":");
        if (PropertyResolverUtils.isNoneValue(delimList)) {
            return true;
        }
        int sepPos = UserInteraction.findPromptComponentLastPosition(value2, delimList);
        return sepPos >= passPos;
    }

    public static String getAuthCommandName(int cmd) {
        switch (cmd) {
            case 50: {
                return "SSH_MSG_USERAUTH_REQUEST";
            }
            case 60: {
                return "SSH_MSG_USERAUTH_INFO_REQUEST";
            }
        }
        return SshConstants.getCommandMessageName(cmd);
    }
}

