/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.password;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface PasswordIdentityProvider {
    public static final PasswordIdentityProvider EMPTY_PASSWORDS_PROVIDER = new PasswordIdentityProvider(){

        @Override
        public Iterable<String> loadPasswords(SessionContext session2) throws IOException, GeneralSecurityException {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public Iterable<String> loadPasswords(SessionContext var1) throws IOException, GeneralSecurityException;

    public static Iterator<String> iteratorOf(SessionContext session2, PasswordIdentityProvider identities, PasswordIdentityProvider passwords) throws IOException, GeneralSecurityException {
        return PasswordIdentityProvider.iteratorOf(session2, PasswordIdentityProvider.resolvePasswordIdentityProvider(session2, identities, passwords));
    }

    public static Iterator<String> iteratorOf(SessionContext session2, PasswordIdentityProvider provider2) throws IOException, GeneralSecurityException {
        return GenericUtils.iteratorOf(provider2 == null ? null : provider2.loadPasswords(session2));
    }

    public static PasswordIdentityProvider resolvePasswordIdentityProvider(SessionContext session2, PasswordIdentityProvider identities, PasswordIdentityProvider passwords) {
        if (passwords == null || identities == passwords) {
            return identities;
        }
        if (identities == null) {
            return passwords;
        }
        return PasswordIdentityProvider.multiProvider(session2, identities, passwords);
    }

    public static PasswordIdentityProvider multiProvider(SessionContext session2, PasswordIdentityProvider ... providers) {
        return PasswordIdentityProvider.multiProvider(session2, GenericUtils.asList(providers));
    }

    public static PasswordIdentityProvider multiProvider(SessionContext session2, Collection<? extends PasswordIdentityProvider> providers) {
        return GenericUtils.isEmpty(providers) ? EMPTY_PASSWORDS_PROVIDER : PasswordIdentityProvider.wrapPasswords(PasswordIdentityProvider.iterableOf(session2, providers));
    }

    public static Iterable<String> iterableOf(SessionContext session2, Collection<? extends PasswordIdentityProvider> providers) {
        Iterable<Supplier> passwordSuppliers = GenericUtils.wrapIterable(providers, p -> () -> {
            try {
                return p.loadPasswords(session2);
            }
            catch (IOException | GeneralSecurityException e2) {
                throw new IllegalArgumentException(e2);
            }
        });
        return GenericUtils.multiIterableSuppliers(passwordSuppliers);
    }

    public static PasswordIdentityProvider wrapPasswords(String ... passwords) {
        return PasswordIdentityProvider.wrapPasswords(GenericUtils.asList(passwords));
    }

    public static PasswordIdentityProvider wrapPasswords(Iterable<String> passwords) {
        return passwords == null ? EMPTY_PASSWORDS_PROVIDER : session2 -> passwords;
    }
}

