/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.password;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class UserAuthPassword
extends AbstractUserAuth {
    public static final String NAME = "password";
    private Iterator<String> passwords;
    private String current;
    private int maxAttempts;
    private int nOfAttempts;

    public UserAuthPassword() {
        super(NAME);
    }

    @Override
    public void init(ClientSession session2, String service) throws Exception {
        super.init(session2, service);
        this.passwords = ClientSession.passwordIteratorOf(session2);
        this.maxAttempts = Math.max(1, CoreModuleProperties.PASSWORD_PROMPTS.getRequired(session2));
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session2, String service) throws Exception {
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport(session2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAuthDataRequest({})[{}] session is not secure", (Object)session2, (Object)service);
            }
            return false;
        }
        this.current = this.resolveAttemptedPassword(session2, service);
        if (this.current == null) {
            PasswordAuthenticationReporter reporter;
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveAttemptedPassword({})[{}] no more passwords to send", (Object)session2, (Object)service);
            }
            if ((reporter = session2.getPasswordAuthenticationReporter()) != null) {
                reporter.signalAuthenticationExhausted(session2, service);
            }
            return false;
        }
        String username = session2.getUsername();
        int length = username.length() + service.length() + GenericUtils.length(this.getName()) + this.current.length() + 32;
        Buffer buffer = session2.createBuffer((byte)50, length);
        this.sendPassword(buffer, session2, this.current, this.current);
        return true;
    }

    protected String resolveAttemptedPassword(ClientSession session2, String service) throws Exception {
        if (this.passwords != null && this.passwords.hasNext()) {
            return this.passwords.next();
        }
        ++this.nOfAttempts;
        if (this.nOfAttempts > this.maxAttempts) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveAttemptedPassword({})[{}] aborting after {} interactive attempts", session2, service, this.maxAttempts);
            }
            return null;
        }
        UserInteraction ui = session2.getUserInteraction();
        if (ui == null || !ui.isInteractionAllowed(session2)) {
            return null;
        }
        return ui.resolveAuthPasswordAttempt(session2);
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session2, String service, Buffer buffer) throws Exception {
        String password;
        boolean interactive;
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session2 + ")[" + service + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport(session2)) {
            if (debugEnabled) {
                this.log.debug("processAuthDataRequest({})[{}] session is not secure", (Object)session2, (Object)service);
            }
            return false;
        }
        if (!UserAuthMethodFactory.isDataIntegrityAuthenticationTransport(session2)) {
            if (debugEnabled) {
                this.log.debug("processAuthDataRequest({})[{}] session is not validated via MAC", (Object)session2, (Object)service);
            }
            return false;
        }
        String prompt = buffer.getString();
        String lang = buffer.getString();
        UserInteraction ui = session2.getUserInteraction();
        try {
            interactive = ui != null && ui.isInteractionAllowed(session2);
            password = interactive ? ui.getUpdatedPassword(session2, prompt, lang) : null;
        }
        catch (Error e2) {
            this.warn("processAuthDataRequest({})[{}] failed ({}) to consult interaction: {}", session2, service, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            throw new RuntimeSshException(e2);
        }
        if (interactive) {
            if (GenericUtils.isEmpty(password)) {
                if (debugEnabled) {
                    this.log.debug("processAuthDataRequest({})[{}] No updated password for prompt={}, lang={}", session2, service, prompt, lang);
                }
                return false;
            }
            this.sendPassword(buffer, session2, password, password);
            return true;
        }
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}] no UI for password change request for prompt={}, lang={}", session2, service, prompt, lang);
        }
        return false;
    }

    protected IoWriteFuture sendPassword(Buffer buffer, ClientSession session2, String oldPassword, String newPassword) throws Exception {
        PasswordAuthenticationReporter reporter;
        boolean modified;
        String username = session2.getUsername();
        String service = this.getService();
        String name = this.getName();
        boolean bl = modified = !Objects.equals(oldPassword, newPassword);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendPassword({})[{}] send SSH_MSG_USERAUTH_REQUEST for {} - modified={}", session2, service, name, modified);
        }
        int length = GenericUtils.length(username) + GenericUtils.length(service) + GenericUtils.length(name) + GenericUtils.length(oldPassword) + (modified ? GenericUtils.length(newPassword) : 0) + 64;
        buffer = session2.createBuffer((byte)50, length);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(modified);
        buffer.putString(oldPassword);
        if (modified) {
            buffer.putString(newPassword);
        }
        if ((reporter = session2.getPasswordAuthenticationReporter()) != null) {
            reporter.signalAuthenticationAttempt(session2, service, oldPassword, modified, newPassword);
        }
        return session2.writePacket(buffer);
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession session2, String service, Buffer buffer) throws Exception {
        PasswordAuthenticationReporter reporter = session2.getPasswordAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationSuccess(session2, service, this.current);
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession session2, String service, boolean partial, List<String> serverMethods, Buffer buffer) throws Exception {
        PasswordAuthenticationReporter reporter = session2.getPasswordAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationFailure(session2, service, this.current, partial, serverMethods);
        }
    }
}

