/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;

public class KeyAgentIdentity
implements PublicKeyIdentity {
    private final SshAgent agent;
    private final KeyPair keyPair;
    private KeyPair resolvedPair;
    private final String comment;

    public KeyAgentIdentity(SshAgent agent, PublicKey key2, String comment) {
        this.agent = Objects.requireNonNull(agent, "No signing agent");
        this.keyPair = new KeyPair(Objects.requireNonNull(key2, "No public key"), null);
        this.comment = comment;
    }

    @Override
    public KeyPair getKeyIdentity() {
        if (this.resolvedPair == null) {
            this.resolvedPair = this.agent.resolveLocalIdentity(this.keyPair.getPublic());
        }
        return this.resolvedPair == null ? this.keyPair : this.resolvedPair;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Map.Entry<String, byte[]> sign(SessionContext session2, String algo, byte[] data2) throws Exception {
        KeyPair kp = this.getKeyIdentity();
        return this.agent.sign(session2, kp.getPublic(), algo, data2);
    }

    public String toString() {
        KeyPair kp = this.getKeyIdentity();
        PublicKey pubKey = kp.getPublic();
        return this.getClass().getSimpleName() + "[" + KeyUtils.getKeyType(pubKey) + "] fingerprint=" + KeyUtils.getFingerPrint(pubKey) + ", comment=" + this.getComment();
    }
}

