/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesHolder;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class KeyPairIdentity
implements PublicKeyIdentity,
SignatureFactoriesHolder {
    private final KeyPair pair;
    private final List<NamedFactory<Signature>> signatureFactories;

    public KeyPairIdentity(SignatureFactoriesManager primary, SignatureFactoriesManager secondary, KeyPair pair) {
        this.signatureFactories = Collections.unmodifiableList(ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(primary, secondary), "No available signature factories", new Object[0]));
        this.pair = Objects.requireNonNull(pair, "No key pair");
    }

    @Override
    public KeyPair getKeyIdentity() {
        return this.pair;
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.signatureFactories;
    }

    @Override
    public Map.Entry<String, byte[]> sign(SessionContext session2, String algo, byte[] data2) throws Exception {
        NamedFactory<Signature> factory2;
        if (GenericUtils.isEmpty(algo)) {
            KeyPair kp = this.getKeyIdentity();
            algo = KeyUtils.getKeyType(kp.getPublic());
            factory2 = SignatureFactory.resolveSignatureFactory(algo, this.getSignatureFactories());
        } else {
            factory2 = NamedResource.findByName(algo, String.CASE_INSENSITIVE_ORDER, this.getSignatureFactories());
        }
        Signature verifier = factory2 == null ? null : (Signature)factory2.create();
        ValidateUtils.checkNotNull(verifier, "No signer could be located for key type=%s", (Object)algo);
        verifier.initSigner(session2, this.pair.getPrivate());
        verifier.update(session2, data2);
        byte[] signature = verifier.sign(session2);
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(factory2.getName(), signature);
    }

    public String toString() {
        KeyPair kp = this.getKeyIdentity();
        PublicKey pubKey = kp.getPublic();
        return this.getClass().getSimpleName() + " type=" + KeyUtils.getKeyType(pubKey) + ", factories=" + this.getSignatureFactoriesNameList() + ", fingerprint=" + KeyUtils.getFingerPrint(pubKey);
    }
}

