/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.sshd.client.channel.AsyncCapableClientChannel;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;

public class ChannelSession
extends AsyncCapableClientChannel {
    protected CloseableExecutorService pumperService;
    protected Future<?> pumper;
    private final Map<String, Object> env = new LinkedHashMap<String, Object>();

    public ChannelSession() {
        super("session", true);
    }

    @Override
    protected RequestHandler.Result handleInternalRequest(String req, boolean wantReply, Buffer buffer) throws IOException {
        switch (req) {
            case "xon-xoff": {
                return this.handleXonXoff(buffer, wantReply);
            }
        }
        return super.handleInternalRequest(req, wantReply, buffer);
    }

    protected RequestHandler.Result handleXonXoff(Buffer buffer, boolean wantReply) throws IOException {
        boolean clientCanDo = buffer.getBoolean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleXonXoff({})[want-reply={}] client-can-do={}", this, wantReply, clientCanDo);
        }
        return RequestHandler.Result.ReplySuccess;
    }

    public Object setEnv(String key2, Object value2) {
        ValidateUtils.checkNotNull(key2, "No key provided");
        if (value2 == null) {
            return this.env.remove(key2);
        }
        return this.env.put(key2, value2);
    }

    protected void sendEnvVariables(Session session2) throws IOException {
        if (MapEntryUtils.size(this.env) > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending env variables ({}) Send SSH_MSG_CHANNEL_REQUEST env: {}", (Object)this, (Object)this.env);
            }
            for (Map.Entry<String, Object> entry : this.env.entrySet()) {
                String key2 = entry.getKey();
                Object value2 = entry.getValue();
                String str = Objects.toString(value2);
                Buffer buffer = session2.createBuffer((byte)98, key2.length() + GenericUtils.length(str) + 32);
                buffer.putInt(this.getRecipient());
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(key2);
                buffer.putString(str);
                this.writePacket(buffer);
            }
        }
    }
}

