/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel.exit;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.channel.AbstractChannelRequestHandler;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.util.EventNotifier;
import org.apache.sshd.common.util.buffer.Buffer;

public abstract class AbstractChannelExitRequestHandler<V>
extends AbstractChannelRequestHandler
implements NamedResource {
    protected final AtomicReference<V> holder;
    protected final EventNotifier<? super String> notifier;

    protected AbstractChannelExitRequestHandler(AtomicReference<V> holder, EventNotifier<? super String> notifier) {
        this.holder = Objects.requireNonNull(holder, "No exit status holder");
        this.notifier = Objects.requireNonNull(notifier, "No event notifier");
    }

    @Override
    public RequestHandler.Result process(Channel channel2, String request2, boolean wantReply, Buffer buffer) throws Exception {
        V value2;
        String name = this.getName();
        if (name.equals(request2) && (value2 = this.processRequestValue(channel2, request2, buffer)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("process({})[{}] wantReply={}: {}", channel2, request2, wantReply, value2);
            }
            this.holder.set(value2);
            this.notifyStateChanged(channel2, request2, value2);
            return RequestHandler.Result.ReplySuccess;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("process({}) wantReply={} ignore request={}", channel2, wantReply, request2);
        }
        return RequestHandler.Result.Unsupported;
    }

    protected abstract V processRequestValue(Channel var1, String var2, Buffer var3) throws Exception;

    protected void notifyStateChanged(Channel channel2, String request2, V value2) {
        String event = this.getEvent(channel2, request2, value2);
        try {
            this.notifier.notifyEvent(event);
            if (this.log.isDebugEnabled()) {
                this.log.debug("notifyStateChanged({})[{}] event={}", channel2, request2, event);
            }
        }
        catch (Exception e2) {
            this.warn("notifyStateChanged({})[{}] Failed ({}) to notify event={}: {}", channel2, request2, e2.getClass().getSimpleName(), event, e2.getMessage(), e2);
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new IllegalArgumentException(e2);
        }
    }

    protected String getEvent(Channel channel2, String request2, V value2) {
        return this.getName();
    }
}

