/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config;

import java.time.Duration;
import java.util.Map;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.core.CoreModuleProperties;

public final class SshClientConfigFileReader {
    public static final String SETENV_PROP = "SetEnv";
    public static final String SENDENV_PROP = "SendEnv";
    public static final String REQUEST_TTY_OPTION = "RequestTTY";
    public static final Property<Duration> CLIENT_LIVECHECK_INTERVAL_PROP = Property.duration("ClientAliveInterval", Duration.ZERO);
    public static final Property<Boolean> CLIENT_LIVECHECK_USE_NULLS = Property.bool("ClientAliveUseNullPackets", false);
    public static final Property<Duration> CLIENT_LIVECHECK_REPLIES_WAIT = Property.duration("ClientAliveReplyWait", Duration.ZERO);
    public static final long DEFAULT_LIVECHECK_REPLY_WAIT = 0L;

    private SshClientConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static <C extends SshClient> C setupClientHeartbeat(C client2, PropertyResolver props) {
        if (client2 == null || props == null) {
            return client2;
        }
        Duration interval = CLIENT_LIVECHECK_INTERVAL_PROP.getRequired(props);
        if (GenericUtils.isNegativeOrNull(interval)) {
            return client2;
        }
        if (CLIENT_LIVECHECK_USE_NULLS.getRequired(props).booleanValue()) {
            CommonModuleProperties.SESSION_HEARTBEAT_TYPE.set(client2, SessionHeartbeatController.HeartbeatType.IGNORE);
            CommonModuleProperties.SESSION_HEARTBEAT_INTERVAL.set(client2, interval);
        } else {
            CoreModuleProperties.HEARTBEAT_INTERVAL.set(client2, interval);
            interval = CLIENT_LIVECHECK_REPLIES_WAIT.getRequired(props);
            if (!GenericUtils.isNegativeOrNull(interval)) {
                CoreModuleProperties.HEARTBEAT_REPLY_WAIT.set(client2, interval);
            }
        }
        return client2;
    }

    public static <C extends SshClient> C setupClientHeartbeat(C client2, Map<String, ?> options2) {
        if (client2 == null || MapEntryUtils.isEmpty(options2)) {
            return client2;
        }
        return SshClientConfigFileReader.setupClientHeartbeat(client2, PropertyResolverUtils.toPropertyResolver(options2));
    }

    public static <C extends SshClient> C configure(C client2, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configure(client2, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureKeyExchanges(client2, props, lenient, ClientBuilder.DH2KEX, ignoreUnsupported);
        SshClientConfigFileReader.setupClientHeartbeat(client2, props);
        return client2;
    }
}

