/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;

public class ConfigFileHostEntryResolver
extends ModifiableFileWatcher
implements HostConfigEntryResolver {
    private final AtomicReference<HostConfigEntryResolver> delegateHolder = new AtomicReference<HostConfigEntryResolver>(HostConfigEntryResolver.EMPTY);

    public ConfigFileHostEntryResolver(Path file2) {
        this(file2, IoUtils.EMPTY_LINK_OPTIONS);
    }

    public ConfigFileHostEntryResolver(Path file2, LinkOption ... options2) {
        super(file2, options2);
    }

    @Override
    public HostConfigEntry resolveEffectiveHost(String host2, int port2, SocketAddress localAddress2, String username, String proxyJump, AttributeRepository context) throws IOException {
        try {
            HostConfigEntryResolver delegate = Objects.requireNonNull(this.resolveEffectiveResolver(host2, port2, username, proxyJump), "No delegate");
            HostConfigEntry entry = delegate.resolveEffectiveHost(host2, port2, localAddress2, username, proxyJump, context);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveEffectiveHost({}@{}:{}/{}) => {}", username, host2, port2, proxyJump, entry);
            }
            return entry;
        }
        catch (Throwable e2) {
            this.debug("resolveEffectiveHost({}@{}:{}/{}) failed ({}) to resolve: {}", username, host2, port2, proxyJump, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw new IOException(e2);
        }
    }

    protected HostConfigEntryResolver resolveEffectiveResolver(String host2, int port2, String username, String proxyJump) throws IOException {
        if (this.checkReloadRequired()) {
            this.delegateHolder.set(HostConfigEntryResolver.EMPTY);
            Path path2 = this.getPath();
            if (this.exists()) {
                List<HostConfigEntry> entries2 = this.reloadHostConfigEntries(path2, host2, port2, username, proxyJump);
                if (GenericUtils.size(entries2) > 0) {
                    this.delegateHolder.set(HostConfigEntry.toHostConfigEntryResolver(entries2));
                }
            } else {
                this.log.info("resolveEffectiveResolver({}@{}:{}/{}) no configuration file at {}", username, host2, port2, proxyJump, path2);
            }
        }
        return this.delegateHolder.get();
    }

    protected List<HostConfigEntry> reloadHostConfigEntries(Path path2, String host2, int port2, String username, String proxyJump) throws IOException {
        List<HostConfigEntry> entries2 = HostConfigEntry.readHostConfigEntries(path2, new OpenOption[0]);
        this.log.info("resolveEffectiveResolver({}@{}:{}) loaded {} entries from {}", username, host2, port2, GenericUtils.size(entries2), path2);
        this.updateReloadAttributes();
        return entries2;
    }
}

