/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.config.hosts.ConfigFileHostEntryResolver;
import org.apache.sshd.client.config.hosts.HostConfigEntry;

public class DefaultConfigFileHostEntryResolver
extends ConfigFileHostEntryResolver {
    public static final DefaultConfigFileHostEntryResolver INSTANCE = new DefaultConfigFileHostEntryResolver(true);
    private final boolean strict;

    public DefaultConfigFileHostEntryResolver(boolean strict) {
        this(HostConfigEntry.getDefaultHostConfigFile(), strict, new LinkOption[0]);
    }

    public DefaultConfigFileHostEntryResolver(Path path2, boolean strict, LinkOption ... options2) {
        super(path2, options2);
        this.strict = strict;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected List<HostConfigEntry> reloadHostConfigEntries(Path path2, String host2, int port2, String username, String proxyJump) throws IOException {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry<String, Object> violation;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadHostConfigEntries({}@{}:{}/{}) check permissions of {}", username, host2, port2, proxyJump, path2);
            }
            if ((violation = DefaultConfigFileHostEntryResolver.validateStrictConfigFilePermissions(path2, new LinkOption[0])) != null) {
                this.log.warn("reloadHostConfigEntries({}@{}:{}/{}) invalid file={} permissions: {}", username, host2, port2, proxyJump, path2, violation.getKey());
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadHostConfigEntries(path2, host2, port2, username, proxyJump);
    }
}

