/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.common.util.GenericUtils;

public class HostPatternValue {
    private Pattern pattern;
    private int port;
    private boolean negated;

    public HostPatternValue() {
    }

    public HostPatternValue(Pattern pattern2, boolean negated) {
        this(pattern2, 0, negated);
    }

    public HostPatternValue(Pattern pattern2, int port2, boolean negated) {
        this.pattern = pattern2;
        this.port = port2;
        this.negated = negated;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern2) {
        this.pattern = pattern2;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port2) {
        this.port = port2;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public String toString() {
        Pattern p = this.getPattern();
        String purePattern = p == null ? null : p.pattern();
        StringBuilder sb = new StringBuilder(GenericUtils.length(purePattern) + 16);
        if (this.isNegated()) {
            sb.append('!');
        }
        int portValue = this.getPort();
        try {
            KnownHostHashValue.appendHostPattern(sb, purePattern, portValue);
        }
        catch (IOException e2) {
            throw new IllegalStateException("Unexpected (" + e2.getClass().getSimpleName() + ") failure to append host pattern of " + purePattern + ":" + portValue + ": " + e2.getMessage(), e2);
        }
        return sb.toString();
    }
}

