/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.client.config.hosts.HostPatternValue;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class HostPatternsHolder {
    public static final char WILDCARD_PATTERN = '*';
    public static final String ALL_HOSTS_PATTERN = String.valueOf('*');
    public static final char SINGLE_CHAR_PATTERN = '?';
    public static final char NEGATION_CHAR_PATTERN = '!';
    public static final String PATTERN_CHARS = new String(new char[]{'*', '?', '!'});
    public static final char PORT_VALUE_DELIMITER = ':';
    public static final char NON_STANDARD_PORT_PATTERN_ENCLOSURE_START_DELIM = '[';
    public static final char NON_STANDARD_PORT_PATTERN_ENCLOSURE_END_DELIM = ']';
    private Collection<HostPatternValue> patterns = new LinkedList<HostPatternValue>();

    protected HostPatternsHolder() {
    }

    public Collection<HostPatternValue> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Collection<HostPatternValue> patterns2) {
        this.patterns = patterns2;
    }

    public boolean isHostMatch(String host2, int port2) {
        return HostPatternsHolder.isHostMatch(host2, port2, this.getPatterns());
    }

    public static boolean isSpecificHostPattern(String pattern2) {
        if (GenericUtils.isEmpty(pattern2)) {
            return false;
        }
        for (int index = 0; index < PATTERN_CHARS.length(); ++index) {
            char ch = PATTERN_CHARS.charAt(index);
            if (pattern2.indexOf(ch) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isHostMatch(String host2, int port2, Collection<HostPatternValue> patterns2) {
        if (GenericUtils.isEmpty(patterns2)) {
            return false;
        }
        boolean matchFound = false;
        for (HostPatternValue pv : patterns2) {
            boolean negated = pv.isNegated();
            if (matchFound && !negated || !HostPatternsHolder.isHostMatch(host2, pv.getPattern()) || !HostPatternsHolder.isPortMatch(port2, pv.getPort())) continue;
            if (negated) {
                return false;
            }
            matchFound = true;
        }
        return matchFound;
    }

    public static boolean isPortMatch(int port1, int port2) {
        return SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port1) == SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port2);
    }

    public static boolean isHostMatch(String host2, Pattern pattern2) {
        if (GenericUtils.isEmpty(host2) || pattern2 == null) {
            return false;
        }
        Matcher m4 = pattern2.matcher(host2);
        return m4.matches();
    }

    public static List<HostPatternValue> parsePatterns(CharSequence ... patterns2) {
        return HostPatternsHolder.parsePatterns(GenericUtils.isEmpty(patterns2) ? Collections.emptyList() : Arrays.asList(patterns2));
    }

    public static List<HostPatternValue> parsePatterns(Collection<? extends CharSequence> patterns2) {
        if (GenericUtils.isEmpty(patterns2)) {
            return Collections.emptyList();
        }
        ArrayList<HostPatternValue> result2 = new ArrayList<HostPatternValue>(patterns2.size());
        for (CharSequence charSequence : patterns2) {
            result2.add(ValidateUtils.checkNotNull(HostPatternsHolder.toPattern(charSequence), "No pattern for %s", (Object)charSequence));
        }
        return result2;
    }

    public static HostPatternValue toPattern(CharSequence patternString) {
        String pattern2 = GenericUtils.replaceWhitespaceAndTrim(Objects.toString(patternString, null));
        if (GenericUtils.isEmpty(pattern2)) {
            return null;
        }
        int patternLen = pattern2.length();
        int port2 = 0;
        StringBuilder sb = new StringBuilder(patternLen);
        if (pattern2.charAt(0) == '[') {
            int pos = GenericUtils.lastIndexOf(pattern2, ':');
            ValidateUtils.checkTrue(pos > 0, "Missing non-standard port value delimiter in %s", (Object)pattern2);
            ValidateUtils.checkTrue(pos < patternLen - 1, "Missing non-standard port value number in %s", (Object)pattern2);
            ValidateUtils.checkTrue(pattern2.charAt(pos - 1) == ']', "Invalid non-standard port value host pattern enclosure delimiters in %s", (Object)pattern2);
            String csPort = pattern2.substring(pos + 1, patternLen);
            port2 = Integer.parseInt(csPort);
            ValidateUtils.checkTrue(port2 > 0 && port2 <= 65535, "Invalid non-start port value (%d) in %s", port2, pattern2);
            pattern2 = pattern2.substring(1, pos - 1);
            patternLen = pattern2.length();
        }
        boolean negated = false;
        block6: for (int curPos = 0; curPos < patternLen; ++curPos) {
            char ch = pattern2.charAt(curPos);
            ValidateUtils.checkTrue(HostPatternsHolder.isValidPatternChar(ch), "Invalid host pattern char in %s", (Object)pattern2);
            switch (ch) {
                case '.': {
                    sb.append('\\').append(ch);
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '!': {
                    ValidateUtils.checkTrue(!negated, "Double negation in %s", (Object)pattern2);
                    ValidateUtils.checkTrue(curPos == 0, "Negation must be 1st char: %s", (Object)pattern2);
                    negated = true;
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return new HostPatternValue(Pattern.compile(sb.toString(), 2), port2, negated);
    }

    public static boolean isValidPatternChar(char ch) {
        if (ch <= ' ' || ch >= '~') {
            return false;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if ("-_.:%".indexOf(ch) >= 0) {
            return true;
        }
        return PATTERN_CHARS.indexOf(ch) >= 0;
    }
}

