/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.apache.sshd.client.config.hosts.KnownHostDigest;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class KnownHostHashValue {
    public static final char HASHED_HOST_DELIMITER = '|';
    public static final NamedFactory<Mac> DEFAULT_DIGEST = KnownHostDigest.SHA1;
    private NamedFactory<Mac> digester = DEFAULT_DIGEST;
    private byte[] saltValue;
    private byte[] digestValue;

    public NamedFactory<Mac> getDigester() {
        return this.digester;
    }

    public void setDigester(NamedFactory<Mac> digester) {
        this.digester = digester;
    }

    public byte[] getSaltValue() {
        return this.saltValue;
    }

    public void setSaltValue(byte[] saltValue) {
        this.saltValue = saltValue;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public void setDigestValue(byte[] digestValue) {
        this.digestValue = digestValue;
    }

    public boolean isHostMatch(String host2, int port2) {
        if (GenericUtils.isEmpty(host2)) {
            return false;
        }
        try {
            byte[] expected = this.getDigestValue();
            byte[] actual = KnownHostHashValue.calculateHashValue(host2, port2, this.getDigester(), this.getSaltValue());
            return Arrays.equals(expected, actual);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new RuntimeSshException("Failed (" + t2.getClass().getSimpleName() + ") to calculate hash value: " + t2.getMessage(), t2);
        }
    }

    public String toString() {
        if (this.getDigester() == null || NumberUtils.isEmpty(this.getSaltValue()) || NumberUtils.isEmpty(this.getDigestValue())) {
            return Objects.toString(this.getDigester(), null) + "-" + BufferUtils.toHex(':', this.getSaltValue()) + "-" + BufferUtils.toHex(':', this.getDigestValue());
        }
        try {
            return KnownHostHashValue.append(new StringBuilder(127), this).toString();
        }
        catch (IOException | RuntimeException e2) {
            return e2.getClass().getSimpleName() + ": " + e2.getMessage();
        }
    }

    public static byte[] calculateHashValue(String host2, int port2, Factory<? extends Mac> factory2, byte[] salt) throws Exception {
        return KnownHostHashValue.calculateHashValue(host2, port2, factory2.create(), salt);
    }

    public static byte[] calculateHashValue(String host2, int port2, Mac mac, byte[] salt) throws Exception {
        mac.init(salt);
        String hostPattern = KnownHostHashValue.createHostPattern(host2, port2);
        byte[] hostBytes = hostPattern.getBytes(StandardCharsets.UTF_8);
        mac.update(hostBytes);
        return mac.doFinal();
    }

    public static String createHostPattern(String host2, int port2) {
        if (SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port2) == 22) {
            return host2;
        }
        try {
            return KnownHostHashValue.appendHostPattern(new StringBuilder(host2.length() + 8), host2, port2).toString();
        }
        catch (IOException e2) {
            throw new UncheckedIOException("Unexpected (" + e2.getClass().getSimpleName() + ") failure to generate host pattern of " + host2 + ":" + port2 + ": " + e2.getMessage(), e2);
        }
    }

    public static <A extends Appendable> A appendHostPattern(A sb, String host2, int port2) throws IOException {
        boolean nonDefaultPort;
        boolean bl = nonDefaultPort = SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port2) != 22;
        if (nonDefaultPort) {
            sb.append('[');
        }
        sb.append(host2);
        if (nonDefaultPort) {
            sb.append(']');
            sb.append(':');
            sb.append(Integer.toString(port2));
        }
        return sb;
    }

    public static <A extends Appendable> A append(A sb, KnownHostHashValue hashValue) throws IOException {
        return hashValue == null ? sb : KnownHostHashValue.append(sb, hashValue.getDigester(), hashValue.getSaltValue(), hashValue.getDigestValue());
    }

    public static <A extends Appendable> A append(A sb, NamedResource factory2, byte[] salt, byte[] digest) throws IOException {
        Base64.Encoder encoder2 = Base64.getEncoder();
        sb.append('|').append(factory2.getName());
        sb.append('|').append(encoder2.encodeToString(salt));
        sb.append('|').append(encoder2.encodeToString(digest));
        return sb;
    }

    public static KnownHostHashValue parse(String patternString) {
        String pattern2;
        return KnownHostHashValue.parse(pattern2, GenericUtils.isEmpty(pattern2 = GenericUtils.replaceWhitespaceAndTrim(patternString)) ? null : new KnownHostHashValue());
    }

    public static <V extends KnownHostHashValue> V parse(String patternString, V value2) {
        String pattern2 = GenericUtils.replaceWhitespaceAndTrim(patternString);
        if (GenericUtils.isEmpty(pattern2)) {
            return value2;
        }
        String[] components = GenericUtils.split(pattern2, '|');
        ValidateUtils.checkTrue(components.length == 4, "Invalid hash pattern (insufficient data): %s", (Object)pattern2);
        ValidateUtils.checkTrue(GenericUtils.isEmpty(components[0]), "Invalid hash pattern (unexpected extra data): %s", (Object)pattern2);
        NamedFactory factory2 = ValidateUtils.checkNotNull(KnownHostDigest.fromName(components[1]), "Invalid hash pattern (unknown digest): %s", (Object)pattern2);
        Base64.Decoder decoder = Base64.getDecoder();
        value2.setDigester(factory2);
        value2.setSaltValue(decoder.decode(components[2]));
        value2.setDigestValue(decoder.decode(components[3]));
        return value2;
    }
}

