/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Path;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.sshd.client.config.keys.ClientIdentityFileWatcher;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

public class ClientIdentitiesWatcher
extends AbstractKeyPairProvider {
    private final Collection<ClientIdentityProvider> providers;

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider2) {
        this(paths, loader, provider2, true);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider2, boolean strict) {
        this(paths, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(loader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(provider2, "No password provider")), strict);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider2) {
        this(paths, loader, provider2, true);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider2, boolean strict) {
        this(ClientIdentitiesWatcher.buildProviders(paths, loader, provider2, strict));
    }

    public ClientIdentitiesWatcher(Collection<ClientIdentityProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Iterable<KeyPair> loadKeys(SessionContext session2) {
        return this.loadKeys(session2, null);
    }

    protected Iterable<KeyPair> loadKeys(SessionContext session2, Predicate<KeyPair> filter2) {
        return ClientIdentityProvider.lazyKeysLoader(this.providers, p -> this.doGetKeyPairs(session2, (ClientIdentityProvider)p), filter2);
    }

    protected Iterable<KeyPair> doGetKeyPairs(SessionContext session2, ClientIdentityProvider p) {
        try {
            Iterable<KeyPair> kp = p.getClientIdentities(session2);
            if (kp == null && this.log.isDebugEnabled()) {
                this.log.debug("loadKeys({}) no key loaded", (Object)p);
            }
            return kp;
        }
        catch (Throwable e2) {
            this.warn("loadKeys({}) failed ({}) to load key: {}", p, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            return null;
        }
    }

    public static List<ClientIdentityProvider> buildProviders(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider2, boolean strict) {
        return ClientIdentitiesWatcher.buildProviders(paths, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(loader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(provider2, "No password provider")), strict);
    }

    public static List<ClientIdentityProvider> buildProviders(Collection<? extends Path> paths, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider2, boolean strict) {
        if (GenericUtils.isEmpty(paths)) {
            return Collections.emptyList();
        }
        return GenericUtils.map(paths, p -> new ClientIdentityFileWatcher((Path)p, loader, provider2, strict));
    }
}

