/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.IdentityUtils;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;

public final class ClientIdentity {
    public static final String ID_FILE_PREFIX = "id_";
    public static final String ID_FILE_SUFFIX = "";
    public static final Function<String, String> ID_GENERATOR = ClientIdentity::getIdentityFileName;

    private ClientIdentity() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String getIdentityType(String name) {
        if (GenericUtils.isEmpty(name) || name.length() <= ID_FILE_PREFIX.length() || !name.startsWith(ID_FILE_PREFIX)) {
            return null;
        }
        return name.substring(ID_FILE_PREFIX.length());
    }

    public static String getIdentityFileName(NamedResource r) {
        return ClientIdentity.getIdentityFileName(r == null ? null : r.getName());
    }

    public static String getIdentityFileName(String type2) {
        return IdentityUtils.getIdentityFileName(ID_FILE_PREFIX, type2, ID_FILE_SUFFIX);
    }

    public static KeyPairProvider loadDefaultKeyPairProvider(boolean strict, boolean supportedOnly, FilePasswordProvider provider2, LinkOption ... options2) throws IOException, GeneralSecurityException {
        return ClientIdentity.loadDefaultKeyPairProvider(PublicKeyEntry.getDefaultKeysFolderPath(), strict, supportedOnly, provider2, options2);
    }

    public static KeyPairProvider loadDefaultKeyPairProvider(Path dir, boolean strict, boolean supportedOnly, FilePasswordProvider provider2, LinkOption ... options2) throws IOException, GeneralSecurityException {
        Map<String, KeyPair> ids = ClientIdentity.loadDefaultIdentities(dir, strict, provider2, options2);
        return IdentityUtils.createKeyPairProvider(ids, supportedOnly);
    }

    public static Map<String, KeyPair> loadDefaultIdentities(boolean strict, FilePasswordProvider provider2, LinkOption ... options2) throws IOException, GeneralSecurityException {
        return ClientIdentity.loadDefaultIdentities(PublicKeyEntry.getDefaultKeysFolderPath(), strict, provider2, options2);
    }

    public static Map<String, KeyPair> loadDefaultIdentities(Path dir, boolean strict, FilePasswordProvider provider2, LinkOption ... options2) throws IOException, GeneralSecurityException {
        return ClientIdentity.loadIdentities(null, dir, strict, BuiltinIdentities.NAMES, ID_GENERATOR, provider2, options2);
    }

    public static Map<String, KeyPair> loadIdentities(SessionContext session2, Path dir, boolean strict, Collection<String> types, Function<? super String, String> idGenerator, FilePasswordProvider provider2, LinkOption ... options2) throws IOException, GeneralSecurityException {
        Map<String, Path> paths = ClientIdentity.scanIdentitiesFolder(dir, strict, types, idGenerator, options2);
        return IdentityUtils.loadIdentities(session2, paths, provider2, IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public static Map<String, Path> scanIdentitiesFolder(Path dir, boolean strict, Collection<String> types, Function<? super String, String> idGenerator, LinkOption ... options2) throws IOException {
        if (GenericUtils.isEmpty(types)) {
            return Collections.emptyMap();
        }
        if (!Files.exists(dir, options2)) {
            return Collections.emptyMap();
        }
        ValidateUtils.checkTrue((boolean)FileInfoExtractor.ISDIR.infoOf(dir, options2), "Not a directory: %s", (Object)dir);
        TreeMap<String, Path> paths = new TreeMap<String, Path>(String.CASE_INSENSITIVE_ORDER);
        for (String t2 : types) {
            String fileName = idGenerator.apply(t2);
            Path p = dir.resolve(fileName);
            if (!Files.exists(p, options2) || strict && KeyUtils.validateStrictKeyFilePermissions(p, options2) != null) continue;
            Path prev = paths.put(t2, p);
            ValidateUtils.checkTrue(prev == null, "Multiple mappings for type=%s", (Object)t2);
        }
        return paths;
    }
}

