/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultCancellableSshFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.GenericUtils;

public class DefaultConnectFuture
extends DefaultCancellableSshFuture<ConnectFuture>
implements ConnectFuture {
    public DefaultConnectFuture(Object id, Object lock) {
        super(id, lock);
    }

    @Override
    public ConnectFuture verify(long timeout2, CancelOption ... options2) throws IOException {
        CancelOption[] cancellation = options2;
        if (GenericUtils.isEmpty(cancellation)) {
            cancellation = new CancelOption[]{CancelOption.CANCEL_ON_TIMEOUT, CancelOption.CANCEL_ON_INTERRUPT};
        }
        long startTime = System.nanoTime();
        ClientSession session2 = this.verifyResult(ClientSession.class, timeout2, cancellation);
        long endTime = System.nanoTime();
        if (this.log.isDebugEnabled()) {
            IoSession ioSession = session2.getIoSession();
            this.log.debug("Connected to {} after {} nanos", (Object)ioSession.getRemoteAddress(), (Object)(endTime - startTime));
        }
        return this;
    }

    @Override
    public ClientSession getSession() {
        Object v = this.getValue();
        if (v instanceof RuntimeException) {
            throw (RuntimeException)v;
        }
        if (v instanceof Error) {
            throw (Error)v;
        }
        if (v instanceof Throwable) {
            throw new RuntimeSshException("Failed to get the session.", (Throwable)v);
        }
        if (v instanceof ClientSession) {
            return (ClientSession)v;
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.getValue() instanceof ClientSession;
    }

    @Override
    public void setSession(ClientSession session2) {
        Objects.requireNonNull(session2, "No client session provided");
        this.setValue(session2);
    }
}

