/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.client.kex.AbstractDHClientKeyExchange;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.CurveSizeIndicator;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyEncapsulationMethod;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public class DHGClient
extends AbstractDHClientKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;
    private KeyEncapsulationMethod.Client kemClient;

    protected DHGClient(DHFactory factory2, Session session2) {
        super(session2);
        this.factory = Objects.requireNonNull(factory2, "No factory");
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(final DHFactory delegate) {
        return new KeyExchangeFactory(){

            @Override
            public String getName() {
                return delegate.getName();
            }

            @Override
            public KeyExchange createKeyExchange(Session session2) throws Exception {
                return new DHGClient(delegate, session2);
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        byte[] e2;
        super.init(v_s, v_c, i_s, i_c);
        this.dh = this.getDH();
        this.hash = this.dh.getHash();
        this.hash.init();
        KeyEncapsulationMethod kem = this.dh.getKeyEncapsulation();
        if (kem == null) {
            e2 = this.updateE(this.dh.getE());
        } else {
            this.kemClient = kem.getClient();
            this.kemClient.init();
            e2 = this.kemClient.getPublicKey();
            byte[] dhE = this.dh.getE();
            int l = e2.length;
            e2 = Arrays.copyOf(e2, l + dhE.length);
            System.arraycopy(dhE, 0, e2, l, dhE.length);
            e2 = this.updateE(e2);
        }
        Session s2 = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("init({})[{}] Send SSH_MSG_KEXDH_INIT", (Object)this, (Object)s2);
        }
        Buffer buffer = s2.createBuffer((byte)30, e2.length + 32);
        this.dh.putE(buffer, e2);
        s2.writePacket(buffer);
    }

    protected AbstractDH getDH() throws Exception {
        return this.factory.create(new Object[0]);
    }

    @Override
    public boolean next(int cmd, Buffer buffer) throws Exception {
        String keyAlg;
        PublicKey serverKey;
        AbstractClientSession session2 = this.getClientSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] process command={}", this, session2, KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        if (cmd != 31) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_REPLY, got " + KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        byte[] k_s = buffer.getBytes();
        byte[] f2 = this.updateF(buffer);
        byte[] sig = buffer.getBytes();
        if (this.kemClient == null) {
            this.dh.setF(f2);
            this.k = this.normalize(this.dh.getK());
        } else {
            try {
                int l = this.kemClient.getEncapsulationLength();
                if (this.dh instanceof CurveSizeIndicator) {
                    int expectedLength = l + ((CurveSizeIndicator)((Object)this.dh)).getByteLength();
                    if (f2.length != expectedLength) {
                        throw new SshException(3, "Wrong F length (should be " + expectedLength + " bytes): " + f2.length);
                    }
                } else if (f2.length <= l) {
                    throw new SshException(3, "Strange F length: " + f2.length + "  <= " + l);
                }
                this.dh.setF(Arrays.copyOfRange(f2, l, f2.length));
                Digest keyHash = this.dh.getHash();
                keyHash.init();
                keyHash.update(this.kemClient.extractSecret(Arrays.copyOf(f2, l)));
                keyHash.update(this.dh.getK());
                this.k = keyHash.digest();
            }
            catch (IllegalArgumentException ex) {
                this.log.error("Key encapsulation error", ex);
                throw new SshException(3, "Key encapsulation error: " + ex.getMessage());
            }
        }
        buffer = new ByteArrayBuffer(k_s);
        PublicKey serverPublicHostKey = serverKey = buffer.getRawPublicKey();
        if (serverKey instanceof OpenSshCertificate) {
            OpenSshCertificate openSshKey = (OpenSshCertificate)serverKey;
            serverPublicHostKey = openSshKey.getCertPubKey();
            try {
                this.verifyCertificate(session2, openSshKey);
            }
            catch (SshException e2) {
                if (CoreModuleProperties.ABORT_ON_INVALID_CERTIFICATE.getRequired(session2).booleanValue()) {
                    throw e2;
                }
                serverKey = openSshKey.getCertPubKey();
                this.log.info("Ignoring invalid certificate {}", (Object)openSshKey.getId(), (Object)e2);
            }
        }
        if (GenericUtils.isEmpty(keyAlg = session2.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS))) {
            throw new SshException("Unsupported server key type: " + serverPublicHostKey.getAlgorithm() + "[" + serverPublicHostKey.getFormat() + "]");
        }
        buffer = new ByteArrayBuffer();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(k_s);
        this.dh.putE(buffer, this.getE());
        this.dh.putF(buffer, f2);
        buffer.putBytes(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        Signature verif = ValidateUtils.checkNotNull(NamedFactory.create(session2.getSignatureFactories(), keyAlg), "No verifier located for algorithm=%s", (Object)keyAlg);
        verif.initVerifier(session2, serverPublicHostKey);
        verif.update(session2, this.h);
        if (!verif.verify(session2, sig)) {
            throw new SshException(3, "KeyExchange signature verification failed for key type=" + keyAlg);
        }
        session2.setServerKey(serverKey);
        return true;
    }

    protected void verifyCertificate(Session session2, OpenSshCertificate openSshKey) throws Exception {
        PublicKey signatureKey = openSshKey.getCaPubKey();
        String keyAlg = KeyUtils.getKeyType(signatureKey);
        String keyId = openSshKey.getId();
        String variant = openSshKey.getSignatureAlgorithm();
        if (!GenericUtils.isEmpty(variant) && "ssh-rsa".equals(KeyUtils.getCanonicalKeyType(variant))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("verifyCertificate({})[id={}] Allowing to use variant {} instead of {}", session2, keyId, variant, keyAlg);
            }
        } else {
            throw new SshException(3, "Found invalid signature alg " + variant + " for key ID=" + keyId);
        }
        keyAlg = variant;
        Signature verif = ValidateUtils.checkNotNull(NamedFactory.create(session2.getSignatureFactories(), keyAlg), "No KeyExchange CA verifier located for algorithm=%s of key ID=%s", keyAlg, keyId);
        verif.initVerifier(session2, signatureKey);
        verif.update(session2, openSshKey.getMessage());
        if (!verif.verify(session2, openSshKey.getSignature())) {
            throw new SshException(3, "KeyExchange CA signature verification failed for key type=" + keyAlg + " of key ID=" + keyId);
        }
        if (!OpenSshCertificate.Type.HOST.equals((Object)openSshKey.getType())) {
            throw new SshException(3, "KeyExchange signature verification failed, not a host key (2) " + (Object)((Object)openSshKey.getType()) + " for key ID=" + keyId);
        }
        if (!OpenSshCertificate.isValidNow(openSshKey)) {
            throw new SshException(3, "KeyExchange signature verification failed, CA expired for key ID=" + keyId);
        }
        SocketAddress connectSocketAddress = this.getClientSession().getConnectAddress();
        if (connectSocketAddress instanceof SshdSocketAddress) {
            connectSocketAddress = ((SshdSocketAddress)connectSocketAddress).toInetSocketAddress();
        }
        if (connectSocketAddress instanceof InetSocketAddress) {
            String hostName = ((InetSocketAddress)connectSocketAddress).getHostString();
            Collection<String> principals = openSshKey.getPrincipals();
            if (GenericUtils.isEmpty(principals) || !principals.contains(hostName)) {
                throw new SshException(3, "KeyExchange signature verification failed, invalid principal " + hostName + " for key ID=" + keyId + " - allowed=" + principals);
            }
        } else {
            throw new SshException(3, "KeyExchange signature verification failed, could not determine connect host for key ID=" + keyId);
        }
        if (!GenericUtils.isEmpty(openSshKey.getCriticalOptions())) {
            throw new SshException(3, "KeyExchange signature verification failed, unrecognized critical options " + openSshKey.getCriticalOptions() + " for key ID=" + keyId);
        }
    }
}

