/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.io.IoUtils;

public class DefaultKnownHostsServerKeyVerifier
extends KnownHostsServerKeyVerifier {
    private final boolean strict;

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier delegate) {
        this(delegate, true);
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier delegate, boolean strict) {
        this(delegate, strict, KnownHostEntry.getDefaultKnownHostsFile(), IoUtils.getLinkOptions(true));
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier delegate, boolean strict, File file2) {
        this(delegate, strict, Objects.requireNonNull(file2, "No file provided").toPath(), IoUtils.getLinkOptions(true));
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier delegate, boolean strict, Path file2, LinkOption ... options2) {
        super(delegate, file2, options2);
        this.strict = strict;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected List<KnownHostsServerKeyVerifier.HostEntryPair> reloadKnownHosts(ClientSession session2, Path file2) throws IOException, GeneralSecurityException {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry<String, Object> violation;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadKnownHosts({}) check permissions", (Object)file2);
            }
            if ((violation = DefaultKnownHostsServerKeyVerifier.validateStrictConfigFilePermissions(file2, new LinkOption[0])) != null) {
                this.log.warn("reloadKnownHosts({}) invalid file permissions: {}", (Object)file2, violation.getKey());
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadKnownHosts(session2, file2);
    }
}

