/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Map;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DelegatingServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    @Override
    public boolean verifyServerKey(ClientSession session2, SocketAddress remoteAddress2, PublicKey serverKey) {
        Map<Object, Object> metadataMap = session2.getMetadataMap();
        Object verifier = metadataMap.get(ServerKeyVerifier.class);
        if (verifier == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("verifyServerKey({}) No verifier found in ClientSession metadata; accepting server key", (Object)remoteAddress2);
            }
            return true;
        }
        return ((ServerKeyVerifier)verifier).verifyServerKey(session2, remoteAddress2, serverKey);
    }
}

