/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.client.keyverifier.ModifiedServerKeyAcceptor;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.UnsupportedSshPublicKey;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class KnownHostsServerKeyVerifier
extends ModifiableFileWatcher
implements ServerKeyVerifier,
ModifiedServerKeyAcceptor {
    public static final String STRICT_CHECKING_OPTION = "StrictHostKeyChecking";
    public static final String KNOWN_HOSTS_FILE_OPTION = "UserKnownHostsFile";
    protected final Object updateLock = new Object();
    private final ServerKeyVerifier delegate;
    private final AtomicReference<Supplier<? extends Collection<HostEntryPair>>> keysSupplier = new AtomicReference<Supplier<Collection<HostEntryPair>>>(this.getKnownHostSupplier(null, this.getPath()));
    private ModifiedServerKeyAcceptor modKeyAcceptor;

    public KnownHostsServerKeyVerifier(ServerKeyVerifier delegate, Path file2) {
        this(delegate, file2, IoUtils.EMPTY_LINK_OPTIONS);
    }

    public KnownHostsServerKeyVerifier(ServerKeyVerifier delegate, Path file2, LinkOption ... options2) {
        super(file2, options2);
        this.delegate = Objects.requireNonNull(delegate, "No delegate");
    }

    public ServerKeyVerifier getDelegateVerifier() {
        return this.delegate;
    }

    public ModifiedServerKeyAcceptor getModifiedServerKeyAcceptor() {
        return this.modKeyAcceptor;
    }

    public void setModifiedServerKeyAcceptor(ModifiedServerKeyAcceptor acceptor) {
        this.modKeyAcceptor = acceptor;
    }

    @Override
    public boolean verifyServerKey(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey) {
        try {
            if (this.checkReloadRequired()) {
                Path file2 = this.getPath();
                if (this.exists()) {
                    this.updateReloadAttributes();
                    this.keysSupplier.set(GenericUtils.memoizeLock(this.getKnownHostSupplier(clientSession, file2)));
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("verifyServerKey({})[{}] missing known hosts file {}", clientSession, remoteAddress2, file2);
                    }
                    this.keysSupplier.set(GenericUtils.memoizeLock(Collections::emptyList));
                }
            }
        }
        catch (Throwable t2) {
            return this.acceptIncompleteHostKeys(clientSession, remoteAddress2, serverKey, t2);
        }
        Collection<HostEntryPair> knownHosts = this.keysSupplier.get().get();
        return this.acceptKnownHostEntries(clientSession, remoteAddress2, serverKey, knownHosts);
    }

    protected Supplier<Collection<HostEntryPair>> getKnownHostSupplier(ClientSession clientSession, Path file2) {
        return () -> {
            try {
                return this.reloadKnownHosts(clientSession, file2);
            }
            catch (Exception e2) {
                this.log.warn("verifyServerKey({}) Could not reload known hosts file {}", clientSession, file2, e2);
                return Collections.emptyList();
            }
        };
    }

    protected void setLoadedHostsEntries(Collection<HostEntryPair> keys2) {
        this.keysSupplier.set(() -> keys2);
    }

    protected List<HostEntryPair> reloadKnownHosts(ClientSession session2, Path file2) throws IOException, GeneralSecurityException {
        List<KnownHostEntry> entries2 = KnownHostEntry.readKnownHostEntries(file2, new OpenOption[0]);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("reloadKnownHosts({}) loaded {} entries", (Object)file2, (Object)entries2.size());
        }
        this.updateReloadAttributes();
        if (GenericUtils.isEmpty(entries2)) {
            return Collections.emptyList();
        }
        ArrayList<HostEntryPair> keys2 = new ArrayList<HostEntryPair>(entries2.size());
        PublicKeyEntryResolver resolver = this.getFallbackPublicKeyEntryResolver();
        for (KnownHostEntry entry : entries2) {
            try {
                PublicKey key2 = this.resolveHostKey(session2, entry, resolver);
                if (key2 == null) continue;
                keys2.add(new HostEntryPair(entry, key2));
            }
            catch (Throwable t2) {
                this.warn("reloadKnownHosts({}) failed ({}) to load key of {}: {}", file2, t2.getClass().getSimpleName(), entry, t2.getMessage(), t2);
            }
        }
        return keys2;
    }

    protected PublicKey resolveHostKey(ClientSession session2, KnownHostEntry entry, PublicKeyEntryResolver resolver) throws IOException, GeneralSecurityException {
        if (entry == null) {
            return null;
        }
        AuthorizedKeyEntry authEntry = ValidateUtils.checkNotNull(entry.getKeyEntry(), "No key extracted from %s", (Object)entry);
        PublicKey key2 = authEntry.resolvePublicKey(session2, resolver);
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveHostKey({}) loaded {}-{}", entry, KeyUtils.getKeyType(key2), KeyUtils.getFingerPrint(key2));
        }
        return key2;
    }

    protected PublicKeyEntryResolver getFallbackPublicKeyEntryResolver() {
        return PublicKeyEntryResolver.UNSUPPORTED;
    }

    protected boolean acceptKnownHostEntries(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey, Collection<HostEntryPair> knownHosts) {
        List<HostEntryPair> hostMatches = this.findKnownHostEntries(clientSession, remoteAddress2, knownHosts);
        if (hostMatches.isEmpty()) {
            return this.acceptUnknownHostKey(clientSession, remoteAddress2, serverKey);
        }
        String serverKeyType = KeyUtils.getKeyType(serverKey);
        List keyMatches = hostMatches.stream().filter(entry -> serverKeyType.equals(entry.getHostEntry().getKeyEntry().getKeyType())).filter(k2 -> KeyUtils.compareKeys(k2.getServerKey(), serverKey)).collect(Collectors.toList());
        if (keyMatches.stream().anyMatch(k2 -> "revoked".equals(k2.getHostEntry().getMarker()))) {
            this.handleRevokedKey(clientSession, remoteAddress2, serverKey);
            return false;
        }
        if (!keyMatches.isEmpty()) {
            return true;
        }
        Optional<HostEntryPair> anyNonRevokedMatch = hostMatches.stream().filter(k2 -> !"revoked".equals(k2.getHostEntry().getMarker())).findAny();
        if (!anyNonRevokedMatch.isPresent()) {
            return this.acceptUnknownHostKey(clientSession, remoteAddress2, serverKey);
        }
        KnownHostEntry entry2 = anyNonRevokedMatch.get().getHostEntry();
        PublicKey expected = anyNonRevokedMatch.get().getServerKey();
        try {
            if (this.acceptModifiedServerKey(clientSession, remoteAddress2, entry2, expected, serverKey)) {
                this.updateModifiedServerKey(clientSession, remoteAddress2, serverKey, knownHosts, anyNonRevokedMatch.get());
                return true;
            }
        }
        catch (Throwable t2) {
            this.warn("acceptKnownHostEntries({})[{}] failed ({}) to accept modified server key: {}", clientSession, remoteAddress2, t2.getClass().getSimpleName(), t2.getMessage(), t2);
        }
        return false;
    }

    protected void updateModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey, Collection<HostEntryPair> knownHosts, HostEntryPair match2) {
        Path file2 = this.getPath();
        try {
            this.updateModifiedServerKey(clientSession, remoteAddress2, match2, serverKey, file2, knownHosts);
        }
        catch (Throwable t2) {
            this.handleModifiedServerKeyUpdateFailure(clientSession, remoteAddress2, match2, serverKey, file2, knownHosts, t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress2, HostEntryPair match2, PublicKey actual, Path file2, Collection<HostEntryPair> knownHosts) throws Exception {
        String matchLine;
        if (match2.getServerKey() instanceof UnsupportedSshPublicKey) {
            this.updateKnownHostsFile(clientSession, remoteAddress2, actual, file2, knownHosts);
            return;
        }
        KnownHostEntry entry = match2.getHostEntry();
        String newLine = this.prepareModifiedServerKeyLine(clientSession, remoteAddress2, entry, matchLine = ValidateUtils.checkNotNullAndNotEmpty(entry.getConfigLine(), "No entry config line"), match2.getServerKey(), actual);
        if (GenericUtils.isEmpty(newLine)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateModifiedServerKey({})[{}] no replacement generated for {}", clientSession, remoteAddress2, matchLine);
            }
            return;
        }
        if (matchLine.equals(newLine)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateModifiedServerKey({})[{}] unmodified updated line for {}", clientSession, remoteAddress2, matchLine);
            }
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        Object object = this.updateLock;
        synchronized (object) {
            int matchingIndex = -1;
            try (BufferedReader rdr = Files.newBufferedReader(file2, StandardCharsets.UTF_8);){
                String line = rdr.readLine();
                while (line != null) {
                    if (matchingIndex >= 0) {
                        lines.add(line);
                    } else if (GenericUtils.isEmpty(line = GenericUtils.trimToEmpty(line))) {
                        lines.add(line);
                    } else {
                        int pos = line.indexOf(35);
                        if (pos == 0) {
                            lines.add(line);
                        } else {
                            if (pos > 0) {
                                line = line.substring(0, pos);
                                line = line.trim();
                            }
                            if (!matchLine.equals(line)) {
                                lines.add(line);
                            } else {
                                lines.add(newLine);
                                matchingIndex = lines.size();
                            }
                        }
                    }
                    line = rdr.readLine();
                }
            }
            ValidateUtils.checkTrue(matchingIndex >= 0, "No match found for line=%s", (Object)matchLine);
            try (BufferedWriter w = Files.newBufferedWriter(file2, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (String l : lines) {
                    w.append(l).append(IoUtils.EOL);
                }
            }
            HostEntryPair hostEntryPair = match2;
            synchronized (hostEntryPair) {
                match2.setServerKey(actual);
                entry.setConfigLine(newLine);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("updateModifiedServerKey({}) replaced '{}' with '{}'", file2, matchLine, newLine);
        }
        this.resetReloadAttributes();
    }

    protected String prepareModifiedServerKeyLine(ClientSession clientSession, SocketAddress remoteAddress2, KnownHostEntry entry, String curLine, PublicKey expected, PublicKey actual) throws Exception {
        if (entry == null || GenericUtils.isEmpty(curLine)) {
            return curLine;
        }
        int pos = curLine.indexOf(32);
        if (curLine.charAt(0) == '@') {
            ++pos;
            while (pos < curLine.length() && curLine.charAt(pos) == ' ') {
                ++pos;
            }
            pos = pos < curLine.length() ? curLine.indexOf(32, pos) : -1;
        }
        ValidateUtils.checkTrue(pos > 0 && pos < curLine.length() - 1, "Missing encoded key in line=%s", (Object)curLine);
        StringBuilder sb = new StringBuilder(curLine.length());
        sb.append(curLine.substring(0, pos));
        PublicKeyEntry.appendPublicKeyEntry(sb.append(' '), actual);
        return sb.toString();
    }

    protected void handleModifiedServerKeyUpdateFailure(ClientSession clientSession, SocketAddress remoteAddress2, HostEntryPair match2, PublicKey serverKey, Path file2, Collection<HostEntryPair> knownHosts, Throwable reason) {
        this.warn("acceptKnownHostEntries({})[{}] failed ({}) to update modified server key of {}: {}", clientSession, remoteAddress2, reason.getClass().getSimpleName(), match2, reason.getMessage(), reason);
    }

    protected List<HostEntryPair> findKnownHostEntries(ClientSession clientSession, SocketAddress remoteAddress2, Collection<HostEntryPair> knownHosts) {
        if (GenericUtils.isEmpty(knownHosts)) {
            return Collections.emptyList();
        }
        Collection<SshdSocketAddress> candidates = this.resolveHostNetworkIdentities(clientSession, remoteAddress2);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("findKnownHostEntries({})[{}] host network identities: {}", clientSession, remoteAddress2, candidates);
        }
        if (GenericUtils.isEmpty(candidates)) {
            return Collections.emptyList();
        }
        ArrayList<HostEntryPair> matches2 = new ArrayList<HostEntryPair>();
        block2: for (HostEntryPair line : knownHosts) {
            KnownHostEntry entry = line.getHostEntry();
            for (SshdSocketAddress host2 : candidates) {
                try {
                    if (!entry.isHostMatch(host2.getHostName(), host2.getPort())) continue;
                    if (debugEnabled) {
                        this.log.debug("findKnownHostEntries({})[{}] matched host={} for entry={}", clientSession, remoteAddress2, host2, entry);
                    }
                    matches2.add(line);
                    continue block2;
                }
                catch (Error | RuntimeException e2) {
                    this.warn("findKnownHostEntries({})[{}] failed ({}) to check host={} for entry={}: {}", clientSession, remoteAddress2, e2.getClass().getSimpleName(), host2, entry.getConfigLine(), e2.getMessage(), e2);
                }
            }
        }
        return matches2;
    }

    protected void handleRevokedKey(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey) {
        this.log.debug("acceptKnownHostEntry({})[{}] key={}-{} marked as revoked", clientSession, remoteAddress2, KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey));
    }

    protected boolean acceptIncompleteHostKeys(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey, Throwable reason) {
        this.warn("Failed ({}) to reload server keys from {}: {}", reason.getClass().getSimpleName(), this.getPath(), reason.getMessage(), reason);
        return this.acceptUnknownHostKey(clientSession, remoteAddress2, serverKey);
    }

    protected boolean acceptUnknownHostKey(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("acceptUnknownHostKey({}) host={}, key={}", clientSession, remoteAddress2, KeyUtils.getFingerPrint(serverKey));
        }
        if (this.delegate.verifyServerKey(clientSession, remoteAddress2, serverKey)) {
            Path file2 = this.getPath();
            Collection<HostEntryPair> keys2 = this.keysSupplier.get().get();
            try {
                this.updateKnownHostsFile(clientSession, remoteAddress2, serverKey, file2, keys2);
            }
            catch (Throwable t2) {
                this.handleKnownHostsFileUpdateFailure(clientSession, remoteAddress2, serverKey, file2, keys2, t2);
            }
            return true;
        }
        return false;
    }

    protected void handleKnownHostsFileUpdateFailure(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey, Path file2, Collection<HostEntryPair> knownHosts, Throwable reason) {
        this.warn("handleKnownHostsFileUpdateFailure({})[{}] failed ({}) to update key={}-{} in {}: {}", clientSession, remoteAddress2, reason.getClass().getSimpleName(), KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey), file2, reason.getMessage(), reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KnownHostEntry updateKnownHostsFile(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey, Path file2, Collection<HostEntryPair> knownHosts) throws Exception {
        KnownHostEntry entry = this.prepareKnownHostEntry(clientSession, remoteAddress2, serverKey);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateKnownHostsFile({})[{}] no entry generated for key={}", clientSession, remoteAddress2, KeyUtils.getFingerPrint(serverKey));
            }
            return null;
        }
        String line = entry.getConfigLine();
        byte[] lineData = line.getBytes(StandardCharsets.UTF_8);
        boolean reuseExisting = Files.exists(file2, new LinkOption[0]) && Files.size(file2) > 0L;
        byte[] eolBytes = IoUtils.getEOLBytes();
        Object object = this.updateLock;
        synchronized (object) {
            try (OutputStream output = reuseExisting ? Files.newOutputStream(file2, StandardOpenOption.APPEND) : Files.newOutputStream(file2, new OpenOption[0]);){
                if (reuseExisting) {
                    output.write(eolBytes);
                }
                output.write(lineData);
                output.write(eolBytes);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("updateKnownHostsFile({}) updated: {}", (Object)file2, (Object)entry);
        }
        this.resetReloadAttributes();
        return entry;
    }

    protected KnownHostEntry prepareKnownHostEntry(ClientSession clientSession, SocketAddress remoteAddress2, PublicKey serverKey) throws Exception {
        Collection<SshdSocketAddress> patterns2 = this.resolveHostNetworkIdentities(clientSession, remoteAddress2);
        if (GenericUtils.isEmpty(patterns2)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(127);
        Random rnd = null;
        for (SshdSocketAddress hostIdentity : patterns2) {
            NamedFactory<Mac> digester;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if ((digester = this.getHostValueDigester(clientSession, remoteAddress2, hostIdentity)) != null) {
                if (rnd == null) {
                    FactoryManager manager = Objects.requireNonNull(clientSession.getFactoryManager(), "No factory manager");
                    Factory<? extends Random> factory2 = Objects.requireNonNull(manager.getRandomFactory(), "No random factory");
                    rnd = Objects.requireNonNull(factory2.create(), "No randomizer created");
                }
                Mac mac = (Mac)digester.create();
                int blockSize = mac.getDefaultBlockSize();
                byte[] salt = new byte[blockSize];
                rnd.fill(salt);
                byte[] digestValue = KnownHostHashValue.calculateHashValue(hostIdentity.getHostName(), hostIdentity.getPort(), mac, salt);
                KnownHostHashValue.append(sb, digester, salt, digestValue);
                continue;
            }
            KnownHostHashValue.appendHostPattern(sb, hostIdentity.getHostName(), hostIdentity.getPort());
        }
        PublicKeyEntry.appendPublicKeyEntry(sb.append(' '), serverKey);
        return KnownHostEntry.parseKnownHostEntry(sb.toString());
    }

    protected NamedFactory<Mac> getHostValueDigester(ClientSession clientSession, SocketAddress remoteAddress2, SshdSocketAddress hostIdentity) {
        return null;
    }

    protected Collection<SshdSocketAddress> resolveHostNetworkIdentities(ClientSession clientSession, SocketAddress remoteAddress2) {
        TreeSet<SocketAddress> candidates = new TreeSet<SocketAddress>(SshdSocketAddress.BY_HOST_AND_PORT);
        candidates.add(SshdSocketAddress.toSshdSocketAddress(remoteAddress2));
        SocketAddress connectAddress = clientSession.getConnectAddress();
        candidates.add(SshdSocketAddress.toSshdSocketAddress(connectAddress));
        return candidates;
    }

    @Override
    public boolean acceptModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress2, KnownHostEntry entry, PublicKey expected, PublicKey actual) throws Exception {
        ModifiedServerKeyAcceptor acceptor = this.getModifiedServerKeyAcceptor();
        if (acceptor != null) {
            return acceptor.acceptModifiedServerKey(clientSession, remoteAddress2, entry, expected, actual);
        }
        this.log.warn("acceptModifiedServerKey({}) mismatched keys presented by {} for entry={}: expected={}-{}, actual={}-{}", clientSession, remoteAddress2, entry, KeyUtils.getKeyType(expected), KeyUtils.getFingerPrint(expected), KeyUtils.getKeyType(actual), KeyUtils.getFingerPrint(actual));
        return false;
    }

    public static class HostEntryPair {
        private KnownHostEntry hostEntry;
        private PublicKey serverKey;

        public HostEntryPair() {
        }

        public HostEntryPair(KnownHostEntry entry, PublicKey key2) {
            this.hostEntry = Objects.requireNonNull(entry, "No entry");
            this.serverKey = Objects.requireNonNull(key2, "No key");
        }

        public KnownHostEntry getHostEntry() {
            return this.hostEntry;
        }

        public void setHostEntry(KnownHostEntry hostEntry) {
            this.hostEntry = hostEntry;
        }

        public PublicKey getServerKey() {
            return this.serverKey;
        }

        public void setServerKey(PublicKey serverKey) {
            this.serverKey = serverKey;
        }

        public String toString() {
            return String.valueOf(this.getHostEntry());
        }
    }
}

