/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class RequiredServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    private final PublicKey requiredKey;

    public RequiredServerKeyVerifier(PublicKey requiredKey) {
        this.requiredKey = requiredKey;
    }

    public final PublicKey getRequiredKey() {
        return this.requiredKey;
    }

    @Override
    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress2, PublicKey serverKey) {
        if (this.requiredKey.equals(serverKey)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Server at {} presented expected key: {}", (Object)remoteAddress2, (Object)BufferUtils.toHex(serverKey.getEncoded()));
            }
            return true;
        }
        this.log.error("Server at {} presented wrong key: {}", (Object)remoteAddress2, (Object)BufferUtils.toHex(serverKey.getEncoded()));
        return false;
    }
}

