/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.forward;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.forward.PortForwardingTracker;
import org.apache.sshd.common.util.net.ConnectionEndpointsIndicator;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class ExplicitPortForwardingTracker
extends PortForwardingTracker
implements ConnectionEndpointsIndicator {
    private final boolean localForwarding;
    private final SshdSocketAddress remoteAddress;

    public ExplicitPortForwardingTracker(ClientSession session2, boolean localForwarding, SshdSocketAddress localAddress2, SshdSocketAddress remoteAddress2, SshdSocketAddress boundAddress) {
        super(session2, localAddress2, boundAddress);
        this.localForwarding = localForwarding;
        this.remoteAddress = Objects.requireNonNull(remoteAddress2, "No remote address specified");
    }

    public boolean isLocalForwarding() {
        return this.localForwarding;
    }

    @Override
    public SshdSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            ClientSession manager = this.getClientSession();
            if (this.isLocalForwarding()) {
                manager.stopLocalPortForwarding(this.getBoundAddress());
            } else {
                manager.stopRemotePortForwarding(this.getRemoteAddress());
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[localForwarding=" + this.isLocalForwarding() + ", remote=" + this.getRemoteAddress() + "]";
    }
}

