/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.forward;

import java.nio.channels.Channel;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public abstract class PortForwardingTracker
implements Channel,
SessionHolder<ClientSession>,
ClientSessionHolder {
    protected final AtomicBoolean open = new AtomicBoolean(true);
    private final ClientSession session;
    private final SshdSocketAddress localAddress;
    private final SshdSocketAddress boundAddress;

    protected PortForwardingTracker(ClientSession session2, SshdSocketAddress localAddress2, SshdSocketAddress boundAddress) {
        this.session = Objects.requireNonNull(session2, "No client session provided");
        this.localAddress = Objects.requireNonNull(localAddress2, "No local address specified");
        this.boundAddress = Objects.requireNonNull(boundAddress, "No bound address specified");
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    public SshdSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SshdSocketAddress getBoundAddress() {
        return this.boundAddress;
    }

    @Override
    public ClientSession getClientSession() {
        return this.session;
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[session=" + this.getClientSession() + ", localAddress=" + this.getLocalAddress() + ", boundAddress=" + this.getBoundAddress() + ", open=" + this.isOpen() + "]";
    }
}

