/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.simple;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionCreator;
import org.apache.sshd.client.simple.AbstractSimpleClient;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class AbstractSimpleClientSessionCreator
extends AbstractSimpleClient
implements ClientSessionCreator {
    private long connectTimeout;
    private long authenticateTimeout;

    protected AbstractSimpleClientSessionCreator() {
        this(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    protected AbstractSimpleClientSessionCreator(long connTimeout, long authTimeout) {
        this.setConnectTimeout(connTimeout);
        this.setAuthenticationTimeout(authTimeout);
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(long timeout2) {
        ValidateUtils.checkTrue(timeout2 > 0L, "Non-positive connect timeout: %d", timeout2);
        this.connectTimeout = timeout2;
    }

    @Override
    public long getAuthenticationTimeout() {
        return this.authenticateTimeout;
    }

    @Override
    public void setAuthenticationTimeout(long timeout2) {
        ValidateUtils.checkTrue(timeout2 > 0L, "Non-positive authentication timeout: %d", timeout2);
        this.authenticateTimeout = timeout2;
    }

    @Override
    public ClientSession sessionLogin(SocketAddress target, String username, String password) throws IOException {
        return this.loginSession(this.connect(username, target), password);
    }

    @Override
    public ClientSession sessionLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.loginSession(this.connect(username, target), identity);
    }

    @Override
    public ClientSession sessionLogin(String uri2, String password) throws IOException {
        return this.loginSession(this.connect(uri2), password);
    }

    @Override
    public ClientSession sessionLogin(String uri2, KeyPair identity) throws IOException {
        return this.loginSession(this.connect(uri2), identity);
    }

    protected ClientSession loginSession(ConnectFuture future, String password) throws IOException {
        return this.authSession((ConnectFuture)future.verify(this.getConnectTimeout()), password);
    }

    protected ClientSession loginSession(ConnectFuture future, KeyPair identity) throws IOException {
        return this.authSession((ConnectFuture)future.verify(this.getConnectTimeout()), identity);
    }

    protected ClientSession authSession(ConnectFuture future, String password) throws IOException {
        ClientSession session2 = (ClientSession)future.getSession();
        session2.addPasswordIdentity(password);
        return this.authSession(session2);
    }

    protected ClientSession authSession(ConnectFuture future, KeyPair identity) throws IOException {
        ClientSession session2 = (ClientSession)future.getSession();
        session2.addPublicKeyIdentity(identity);
        return this.authSession(session2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSession authSession(ClientSession clientSession) throws IOException {
        ClientSession session2 = clientSession;
        IOException err = null;
        try {
            AuthFuture auth = session2.auth();
            auth.verify(this.getAuthenticationTimeout());
            session2 = null;
        }
        catch (IOException e2) {
            err = ExceptionUtils.accumulateException(err, e2);
        }
        finally {
            if (session2 != null) {
                try {
                    session2.close();
                }
                catch (IOException e3) {
                    err = ExceptionUtils.accumulateException(err, e3);
                }
            }
        }
        if (err != null) {
            throw err;
        }
        return clientSession;
    }

    public static SimpleClient wrap(final ClientSessionCreator creator, final Channel channel2) {
        Objects.requireNonNull(creator, "No sessions creator");
        Objects.requireNonNull(channel2, "No channel");
        return new AbstractSimpleClientSessionCreator(){

            @Override
            public ConnectFuture connect(String uri2) throws IOException {
                return creator.connect(uri2);
            }

            @Override
            public ConnectFuture connect(String username, String host2, int port2) throws IOException {
                return creator.connect(username, host2, port2);
            }

            @Override
            public ConnectFuture connect(String username, String host2, int port2, SocketAddress localAddress2) throws IOException {
                return creator.connect(username, host2, port2, localAddress2);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress address) throws IOException {
                return creator.connect(username, address);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress targetAddress, SocketAddress localAddress2) throws IOException {
                return creator.connect(username, targetAddress, localAddress2);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig) throws IOException {
                return creator.connect(hostConfig);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig, SocketAddress localAddress2) throws IOException {
                return creator.connect(hostConfig, localAddress2);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context, SocketAddress localAddress2) throws IOException {
                return creator.connect(hostConfig, context, localAddress2);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress targetAddress, AttributeRepository context, SocketAddress localAddress2) throws IOException {
                return creator.connect(username, targetAddress, context, localAddress2);
            }

            @Override
            public ConnectFuture connect(String username, String host2, int port2, AttributeRepository context, SocketAddress localAddress2) throws IOException {
                return creator.connect(username, host2, port2, context, localAddress2);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context) throws IOException {
                return creator.connect(hostConfig, context);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress address, AttributeRepository context) throws IOException {
                return creator.connect(username, address, context);
            }

            @Override
            public ConnectFuture connect(String username, String host2, int port2, AttributeRepository context) throws IOException {
                return creator.connect(username, host2, port2, context);
            }

            @Override
            public boolean isOpen() {
                return channel2.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel2.close();
            }

            public String toString() {
                return SimpleClient.class.getSimpleName() + "[" + channel2 + "]";
            }
        };
    }
}

