/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.simple;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.simple.SimpleClientConfigurator;
import org.apache.sshd.common.util.ValidateUtils;

public interface SimpleSessionClient
extends SimpleClientConfigurator,
Channel {
    default public ClientSession sessionLogin(String host2, String username, String password) throws IOException {
        return this.sessionLogin(host2, 22, username, password);
    }

    default public ClientSession sessionLogin(String host2, int port2, String username, String password) throws IOException {
        return this.sessionLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host2, "No host")), port2, username, password);
    }

    default public ClientSession sessionLogin(String host2, String username, KeyPair identity) throws IOException {
        return this.sessionLogin(host2, 22, username, identity);
    }

    default public ClientSession sessionLogin(String host2, int port2, String username, KeyPair identity) throws IOException {
        return this.sessionLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host2, "No host")), port2, username, identity);
    }

    default public ClientSession sessionLogin(InetAddress host2, String username, String password) throws IOException {
        return this.sessionLogin(host2, 22, username, password);
    }

    default public ClientSession sessionLogin(InetAddress host2, int port2, String username, String password) throws IOException {
        return this.sessionLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host2, "No host address"), port2), username, password);
    }

    default public ClientSession sessionLogin(InetAddress host2, String username, KeyPair identity) throws IOException {
        return this.sessionLogin(host2, 22, username, identity);
    }

    default public ClientSession sessionLogin(InetAddress host2, int port2, String username, KeyPair identity) throws IOException {
        return this.sessionLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host2, "No host address"), port2), username, identity);
    }

    public ClientSession sessionLogin(SocketAddress var1, String var2, String var3) throws IOException;

    public ClientSession sessionLogin(SocketAddress var1, String var2, KeyPair var3) throws IOException;

    public ClientSession sessionLogin(String var1, String var2) throws IOException;

    public ClientSession sessionLogin(String var1, KeyPair var2) throws IOException;
}

