/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.util.MapEntryUtils;

public interface AttributeRepository {
    public int getAttributesCount();

    public <T> T getAttribute(AttributeKey<T> var1);

    default public <T> T resolveAttribute(AttributeKey<T> key2) {
        return this.getAttribute(key2);
    }

    public Collection<AttributeKey<?>> attributeKeys();

    public static <A> AttributeRepository ofKeyValuePair(AttributeKey<A> key2, A value2) {
        Objects.requireNonNull(key2, "No key provided");
        Objects.requireNonNull(value2, "No value provided");
        return AttributeRepository.ofAttributesMap(Collections.singletonMap(key2, value2));
    }

    public static AttributeRepository ofAttributesMap(final Map<AttributeKey<?>, ?> attributes2) {
        return new AttributeRepository(){

            @Override
            public int getAttributesCount() {
                return attributes2.size();
            }

            @Override
            public <T> T getAttribute(AttributeKey<T> key2) {
                Objects.requireNonNull(key2, "No key provided");
                return MapEntryUtils.isEmpty(attributes2) ? null : (T)attributes2.get(key2);
            }

            @Override
            public Collection<AttributeKey<?>> attributeKeys() {
                return MapEntryUtils.isEmpty(attributes2) ? Collections.emptySet() : new HashSet(attributes2.keySet());
            }

            public String toString() {
                return AttributeRepository.class.getSimpleName() + "[" + attributes2 + "]";
            }
        };
    }

    public static class AttributeKey<T> {
    }
}

