/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;

public interface NamedFactory<T>
extends Factory<T>,
NamedResource {
    public static <T> T create(Collection<? extends NamedFactory<? extends T>> factories, String name) {
        NamedFactory<T> f2 = NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, factories);
        if (f2 != null) {
            return f2.create();
        }
        return null;
    }

    public static <S extends OptionalFeature, E extends NamedResource> List<E> setUpTransformedFactories(boolean ignoreUnsupported, Collection<? extends S> preferred, Function<? super S, ? extends E> xform) {
        return preferred.stream().filter(f2 -> ignoreUnsupported ? f2.isSupported() : true).map(xform).collect(Collectors.toList());
    }

    public static <E extends NamedResource & OptionalFeature> List<E> setUpBuiltinFactories(boolean ignoreUnsupported, Collection<? extends E> preferred) {
        return preferred.stream().filter(f2 -> ignoreUnsupported ? ((OptionalFeature)((Object)f2)).isSupported() : true).collect(Collectors.toList());
    }
}

