/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface NamedResource {
    public static final Function<NamedResource, String> NAME_EXTRACTOR = input -> input == null ? null : input.getName();
    public static final Comparator<NamedResource> BY_NAME_COMPARATOR = Comparator.comparing(NAME_EXTRACTOR, String.CASE_INSENSITIVE_ORDER);

    public String getName();

    public static List<String> getNameList(Collection<? extends NamedResource> resources2) {
        return GenericUtils.map(resources2, NamedResource::getName);
    }

    public static String getNames(Collection<? extends NamedResource> resources2) {
        List<String> nameList = NamedResource.getNameList(resources2);
        return GenericUtils.join(nameList, ',');
    }

    public static <R extends NamedResource> R removeByName(String name, Comparator<? super String> c2, Collection<? extends R> resources2) {
        R r = NamedResource.findByName(name, c2, resources2);
        if (r != null) {
            resources2.remove(r);
        }
        return r;
    }

    public static <R extends NamedResource> R findByName(String name, Comparator<? super String> c2, Collection<? extends R> resources2) {
        return (R)(GenericUtils.isEmpty(name) || GenericUtils.isEmpty(resources2) ? null : (NamedResource)GenericUtils.stream(resources2).filter(r -> c2.compare(name, r.getName()) == 0).findFirst().orElse(null));
    }

    public static <R extends NamedResource> R findFirstMatchByName(Collection<String> names2, Comparator<? super String> c2, Collection<? extends R> resources2) {
        return (R)(GenericUtils.isEmpty(names2) || GenericUtils.isEmpty(resources2) ? null : (NamedResource)GenericUtils.stream(resources2).filter(r -> GenericUtils.findFirstMatchingMember(n -> c2.compare((String)n, r.getName()) == 0, names2) != null).findFirst().orElse(null));
    }

    public static NamedResource ofName(final String name) {
        return new NamedResource(){

            @Override
            public String getName() {
                return name;
            }

            public String toString() {
                return this.getName();
            }
        };
    }

    public static int safeCompareByName(NamedResource r1, NamedResource r2, boolean caseSensitive) {
        String n1 = r1 == null ? null : r1.getName();
        String n2 = r2 == null ? null : r2.getName();
        return GenericUtils.safeCompare(n1, n2, caseSensitive);
    }
}

