/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class PropertyResolverUtils {
    public static final String NONE_VALUE = "none";
    public static final NavigableSet<String> TRUE_VALUES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"true", "t", "yes", "y", "on"}));
    public static final NavigableSet<String> FALSE_VALUES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"false", "f", "no", "n", "off"}));

    private PropertyResolverUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean isNoneValue(String v) {
        return NONE_VALUE.equalsIgnoreCase(v);
    }

    public static long getLongProperty(PropertyResolver resolver, String name, long defaultValue) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(resolver, name), defaultValue);
    }

    public static long getLongProperty(Map<String, ?> props, String name, long defaultValue) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(props, name), defaultValue);
    }

    public static long toLong(Object value2, long defaultValue) {
        if (value2 == null) {
            return defaultValue;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        return Long.parseLong(value2.toString());
    }

    public static Long getLong(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(resolver, name));
    }

    public static Long getLong(Map<String, ?> props, String name) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(props, name));
    }

    public static Long toLong(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Long) {
            return (Long)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        return Long.valueOf(value2.toString());
    }

    public static <E extends Enum<E>> E toEnum(Class<E> enumType, Object value2, boolean failIfNoMatch, Collection<E> available) {
        if (value2 == null) {
            return null;
        }
        if (enumType.isInstance(value2)) {
            return (E)((Enum)enumType.cast(value2));
        }
        if (value2 instanceof CharSequence) {
            String name = value2.toString();
            if (GenericUtils.size(available) > 0) {
                for (Enum v : available) {
                    if (!name.equalsIgnoreCase(v.name())) continue;
                    return (E)v;
                }
            }
            if (failIfNoMatch) {
                throw new NoSuchElementException("No match found for " + enumType.getSimpleName() + "[" + name + "]");
            }
            return null;
        }
        throw new IllegalArgumentException("Bad value type for enum conversion: " + value2.getClass().getSimpleName());
    }

    public static Object updateProperty(PropertyResolver resolver, String name, long value2) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value2);
    }

    public static Object updateProperty(Map<String, Object> props, String name, long value2) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value2);
    }

    public static int getIntProperty(PropertyResolver resolver, String name, int defaultValue) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(resolver, name), defaultValue);
    }

    public static int getIntProperty(Map<String, ?> props, String name, int defaultValue) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(props, name), defaultValue);
    }

    public static int toInteger(Object value2, int defaultValue) {
        if (value2 == null) {
            return defaultValue;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        return Integer.parseInt(value2.toString());
    }

    public static Integer getInteger(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(resolver, name));
    }

    public static Integer getInteger(Map<String, ?> props, String name) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(props, name));
    }

    public static Integer toInteger(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        return Integer.valueOf(value2.toString());
    }

    public static Object updateProperty(PropertyResolver resolver, String name, int value2) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value2);
    }

    public static Object updateProperty(Map<String, Object> props, String name, int value2) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value2);
    }

    public static boolean getBooleanProperty(PropertyResolver resolver, String name, boolean defaultValue) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.getObject(resolver, name), defaultValue);
    }

    public static boolean getBooleanProperty(Map<String, ?> props, String name, boolean defaultValue) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.getObject(props, name), defaultValue);
    }

    public static boolean toBoolean(Object value2, boolean defaultValue) {
        Boolean bool = PropertyResolverUtils.toBoolean(value2);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }

    public static Boolean getBoolean(PropertyResolver resolver, String name) {
        Object propValue = PropertyResolverUtils.resolvePropertyValue(resolver, name);
        return PropertyResolverUtils.toBoolean(propValue);
    }

    public static Boolean getBoolean(Map<String, ?> props, String name) {
        Object propValue = PropertyResolverUtils.resolvePropertyValue(props, name);
        return PropertyResolverUtils.toBoolean(propValue);
    }

    public static Boolean toBoolean(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof CharSequence) {
            return PropertyResolverUtils.parseBoolean(value2.toString());
        }
        throw new UnsupportedOperationException("Cannot convert " + value2.getClass().getSimpleName() + "[" + value2 + "] to boolean");
    }

    public static Boolean parseBoolean(String value2) {
        if (GenericUtils.isEmpty(value2)) {
            return null;
        }
        if (TRUE_VALUES.contains(value2)) {
            return Boolean.TRUE;
        }
        if (FALSE_VALUES.contains(value2)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Unknown boolean value: '" + value2 + "'");
    }

    public static Object updateProperty(PropertyResolver resolver, String name, boolean value2) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value2);
    }

    public static Object updateProperty(Map<String, Object> props, String name, boolean value2) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value2);
    }

    public static String getStringProperty(PropertyResolver resolver, String name, String defaultValue) {
        String value2 = PropertyResolverUtils.getString(resolver, name);
        if (GenericUtils.isEmpty(value2)) {
            return defaultValue;
        }
        return value2;
    }

    public static String getStringProperty(Map<String, ?> props, String name, String defaultValue) {
        Object value2 = PropertyResolverUtils.resolvePropertyValue(props, name);
        if (value2 == null) {
            return defaultValue;
        }
        return Objects.toString(value2);
    }

    public static Charset getCharset(PropertyResolver resolver, String name, Charset defaultValue) {
        Object value2 = PropertyResolverUtils.getObject(resolver, name);
        return value2 == null ? defaultValue : PropertyResolverUtils.toCharset(value2);
    }

    public static Charset getCharset(Map<String, ?> props, String name, Charset defaultValue) {
        Object value2 = PropertyResolverUtils.getObject(props, name);
        return value2 == null ? defaultValue : PropertyResolverUtils.toCharset(value2);
    }

    public static Charset toCharset(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Charset) {
            return (Charset)value2;
        }
        if (value2 instanceof CharSequence) {
            return Charset.forName(value2.toString());
        }
        throw new IllegalArgumentException("Invalid charset conversion value: " + value2);
    }

    public static String getString(PropertyResolver resolver, String name) {
        Object value2 = PropertyResolverUtils.getObject(resolver, name);
        return Objects.toString(value2, null);
    }

    public static String getString(Map<String, ?> props, String name) {
        Object value2 = PropertyResolverUtils.getObject(props, name);
        return Objects.toString(value2, null);
    }

    public static Object getObject(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.resolvePropertyValue(resolver, name);
    }

    public static Object getObject(PropertyResolver resolver, String name, Object defaultValue) {
        Object value2 = PropertyResolverUtils.resolvePropertyValue(resolver, name);
        return value2 != null ? value2 : defaultValue;
    }

    public static Object getObject(Map<String, ?> props, String name) {
        return PropertyResolverUtils.resolvePropertyValue(props, name);
    }

    public static Object resolvePropertyValue(Map<String, ?> props, String name) {
        String key2 = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        return props != null ? props.get(key2) : null;
    }

    public static Object updateProperty(PropertyResolver resolver, String name, Object value2) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value2);
    }

    public static Object updateProperty(Map<String, Object> props, String name, Object value2) {
        String key2 = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        if (value2 == null || value2 instanceof CharSequence && GenericUtils.isEmpty((CharSequence)value2)) {
            return props.remove(key2);
        }
        return props.put(key2, value2);
    }

    public static Object resolvePropertyValue(PropertyResolver resolver, String name) {
        String key2 = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        for (PropertyResolver r = resolver; r != null; r = r.getParentPropertyResolver()) {
            Map<String, Object> props = r.getProperties();
            Object value2 = PropertyResolverUtils.getObject(props, key2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public static Map<String, Object> resolvePropertiesSource(PropertyResolver resolver, String name) {
        String key2 = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        for (PropertyResolver r = resolver; r != null; r = r.getParentPropertyResolver()) {
            Map<String, Object> props = r.getProperties();
            Object value2 = PropertyResolverUtils.getObject(props, key2);
            if (value2 == null) continue;
            return props;
        }
        return null;
    }

    public static PropertyResolver toPropertyResolver(Properties props) {
        if (MapEntryUtils.isEmpty(props)) {
            return PropertyResolver.EMPTY;
        }
        Set<String> names2 = props.stringPropertyNames();
        ConcurrentHashMap<String, String> propsMap = new ConcurrentHashMap<String, String>(GenericUtils.size(names2));
        for (String key2 : names2) {
            String value2 = props.getProperty(key2);
            if (value2 == null) continue;
            propsMap.put(key2, value2);
        }
        return PropertyResolverUtils.toPropertyResolver(propsMap);
    }

    public static PropertyResolver toPropertyResolver(Map<String, ?> props) {
        return PropertyResolverUtils.toPropertyResolver(props, null);
    }

    public static PropertyResolver toPropertyResolver(final Map<String, ?> props, final PropertyResolver parent) {
        return new PropertyResolver(){

            @Override
            public PropertyResolver getParentPropertyResolver() {
                return parent;
            }

            @Override
            public Map<String, Object> getProperties() {
                return props;
            }

            public String toString() {
                return Objects.toString(props);
            }
        };
    }
}

