/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public final class SyspropsMapWrapper
implements Map<String, Object> {
    public static final String SYSPROPS_MAPPED_PREFIX = "org.apache.sshd.config";
    public static final PropertyResolver RAW_PROPS_RESOLVER = PropertyResolverUtils.toPropertyResolver(System.getProperties());
    public static final SyspropsMapWrapper INSTANCE = new SyspropsMapWrapper();
    public static final PropertyResolver SYSPROPS_RESOLVER = new PropertyResolver(){

        @Override
        public Map<String, Object> getProperties() {
            return INSTANCE;
        }

        @Override
        public PropertyResolver getParentPropertyResolver() {
            return null;
        }

        public String toString() {
            return "SYSPROPS";
        }
    };

    private SyspropsMapWrapper() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("sysprops#clear() N/A");
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.get(key2) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        Properties props = System.getProperties();
        for (String key2 : props.stringPropertyNames()) {
            String v;
            if (!SyspropsMapWrapper.isMappedSyspropKey(key2) || !Objects.equals(v = props.getProperty(key2), value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Properties props = System.getProperties();
        TreeSet<Map.Entry<String, Object>> entries2 = new TreeSet<Map.Entry<String, Object>>(MapEntryUtils.byKeyEntryComparator());
        for (String key2 : props.stringPropertyNames()) {
            String v;
            if (!SyspropsMapWrapper.isMappedSyspropKey(key2) || (v = props.getProperty(key2)) == null) continue;
            String unmappedKey = SyspropsMapWrapper.getUnmappedSyspropKey(key2);
            entries2.add(new AbstractMap.SimpleImmutableEntry<String, String>(unmappedKey, v));
        }
        return entries2;
    }

    @Override
    public Object get(Object key2) {
        String propName = SyspropsMapWrapper.getMappedSyspropKey(key2);
        return key2 instanceof String ? System.getProperty(propName) : null;
    }

    @Override
    public boolean isEmpty() {
        return GenericUtils.isEmpty(this.keySet());
    }

    @Override
    public Set<String> keySet() {
        return System.getProperties().stringPropertyNames().stream().filter(SyspropsMapWrapper::isMappedSyspropKey).map(SyspropsMapWrapper::getUnmappedSyspropKey).collect(Collectors.toSet());
    }

    @Override
    public Object put(String key2, Object value2) {
        throw new UnsupportedOperationException("sysprops#put(" + key2 + ")[" + value2 + "] N/A");
    }

    @Override
    public void putAll(Map<? extends String, ?> m4) {
        throw new UnsupportedOperationException("sysprops#putAll(" + m4 + ") N/A");
    }

    @Override
    public Object remove(Object key2) {
        throw new UnsupportedOperationException("sysprops#remove(" + key2 + ") N/A");
    }

    @Override
    public int size() {
        return GenericUtils.size(this.keySet());
    }

    @Override
    public Collection<Object> values() {
        Properties props = System.getProperties();
        return props.stringPropertyNames().stream().filter(SyspropsMapWrapper::isMappedSyspropKey).map(props::get).collect(Collectors.toList());
    }

    public String toString() {
        return Objects.toString(this.entrySet(), null);
    }

    public static boolean isMappedSyspropKey(String key2) {
        return GenericUtils.length(key2) > SYSPROPS_MAPPED_PREFIX.length() + 1 && key2.startsWith(SYSPROPS_MAPPED_PREFIX) && key2.charAt(SYSPROPS_MAPPED_PREFIX.length()) == '.';
    }

    public static String getUnmappedSyspropKey(Object key2) {
        String s2 = Objects.toString(key2);
        return SyspropsMapWrapper.isMappedSyspropKey(s2) ? s2.substring(SYSPROPS_MAPPED_PREFIX.length() + 1) : s2;
    }

    public static String getMappedSyspropKey(Object key2) {
        return "org.apache.sshd.config." + key2;
    }
}

