/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.auth.UserAuthInstance;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

public interface UserAuthFactoriesManager<S extends SessionContext, M extends UserAuthInstance<S>, F extends UserAuthMethodFactory<S, M>> {
    public List<F> getUserAuthFactories();

    default public String getUserAuthFactoriesNameList() {
        return NamedResource.getNames(this.getUserAuthFactories());
    }

    default public List<String> getUserAuthFactoriesNames() {
        return NamedResource.getNameList(this.getUserAuthFactories());
    }

    public void setUserAuthFactories(List<F> var1);

    default public void setUserAuthFactoriesNameList(String names2) {
        this.setUserAuthFactoriesNames(GenericUtils.split(names2, ','));
    }

    default public void setUserAuthFactoriesNames(String ... names2) {
        this.setUserAuthFactoriesNames(GenericUtils.isEmpty((Object[])names2) ? Collections.emptyList() : Arrays.asList(names2));
    }

    public void setUserAuthFactoriesNames(Collection<String> var1);
}

