/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.Closeable;
import java.io.IOException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;

public class SimpleIoOutputStream
extends AbstractCloseable
implements IoOutputStream {
    protected final ChannelOutputStream os;

    public SimpleIoOutputStream(ChannelOutputStream os) {
        this.os = os;
    }

    @Override
    protected void doCloseImmediately() {
        IoUtils.closeQuietly((Closeable)this.os);
        super.doCloseImmediately();
    }

    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        this.os.write(buffer.array(), buffer.rpos(), buffer.available());
        this.os.flush();
        DefaultIoWriteFuture f2 = new DefaultIoWriteFuture(this, null);
        f2.setValue(true);
        return f2;
    }

    protected static class DefaultIoWriteFuture
    extends AbstractIoWriteFuture {
        public DefaultIoWriteFuture(Object id, Object lock) {
            super(id, lock);
        }
    }
}

