/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseCipher
implements Cipher {
    static CipherFactory factory = SecurityUtils::getCipher;
    static boolean alwaysReInit;
    protected Cipher.Mode mode;
    private javax.crypto.Cipher cipher;
    private final int ivsize;
    private final int authSize;
    private final int kdfSize;
    private final String algorithm;
    private final int keySize;
    private final int blkSize;
    private final String transformation;
    private String s;
    private SecretKey secretKey;

    public BaseCipher(int ivsize, int authSize, int kdfSize, String algorithm, int keySize, String transformation, int blkSize) {
        this.ivsize = ivsize;
        this.authSize = authSize;
        this.kdfSize = kdfSize;
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No algorithm");
        this.keySize = keySize;
        this.transformation = ValidateUtils.checkNotNullAndNotEmpty(transformation, "No transformation");
        this.blkSize = blkSize;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public int getIVSize() {
        return this.ivsize;
    }

    @Override
    public int getAuthenticationTagSize() {
        return this.authSize;
    }

    @Override
    public int getKdfSize() {
        return this.kdfSize;
    }

    @Override
    public int getCipherBlockSize() {
        return this.blkSize;
    }

    @Override
    public void init(Cipher.Mode mode, byte[] key2, byte[] iv) throws Exception {
        key2 = this.initializeKeyData(mode, key2, this.getKdfSize());
        iv = this.initializeIVData(mode, iv, this.getIVSize());
        this.cipher = this.createCipherInstance(mode, key2, iv);
    }

    protected javax.crypto.Cipher getCipherInstance() {
        return this.cipher;
    }

    protected javax.crypto.Cipher createCipherInstance(Cipher.Mode mode, byte[] key2, byte[] iv) throws Exception {
        javax.crypto.Cipher instance = factory.getCipher(this.getTransformation());
        this.mode = mode;
        this.secretKey = new SecretKeySpec(key2, this.getAlgorithm());
        instance.init(Cipher.Mode.Encrypt.equals((Object)mode) ? 1 : 2, (Key)this.secretKey, new IvParameterSpec(iv));
        return instance;
    }

    protected byte[] initializeKeyData(Cipher.Mode mode, byte[] key2, int reqLen) {
        return BaseCipher.resize(key2, reqLen);
    }

    protected byte[] initializeIVData(Cipher.Mode mode, byte[] iv, int reqLen) {
        return BaseCipher.resize(iv, reqLen);
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) throws Exception {
        try {
            int stored = this.cipher.update(input, inputOffset, inputLen, input, inputOffset);
            if (stored < inputLen || alwaysReInit) {
                if ((stored += this.cipher.doFinal(input, inputOffset + stored)) != inputLen) {
                    throw new GeneralSecurityException("Cipher.doFinal() did not return all bytes: " + stored + " != " + inputLen);
                }
                this.reInit(input, inputOffset, inputLen);
            }
        }
        catch (GeneralSecurityException e2) {
            throw new GeneralSecurityException("BaseCipher.update() for " + this.getTransformation() + '/' + this.getKeySize() + " failed (" + (Object)((Object)this.mode) + ')', e2);
        }
    }

    protected void reInit(byte[] processed, int offset, int length) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.init(Cipher.Mode.Encrypt.equals((Object)this.mode) ? 1 : 2, (Key)this.secretKey, this.determineNewParameters(processed, offset, length));
    }

    protected AlgorithmParameterSpec determineNewParameters(byte[] processed, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass() + " needs to override determineNewParameters()");
    }

    @Override
    public void updateAAD(byte[] data2, int offset, int length) throws Exception {
        throw new UnsupportedOperationException(this.getClass() + " does not support AAD operations");
    }

    protected static byte[] resize(byte[] data2, int size2) {
        if (data2.length > size2) {
            byte[] tmp = new byte[size2];
            System.arraycopy(data2, 0, tmp, 0, size2);
            data2 = tmp;
        }
        return data2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BaseCipher baseCipher = this;
        synchronized (baseCipher) {
            if (this.s == null) {
                this.s = this.getClass().getSimpleName() + "[" + this.getAlgorithm() + ", ivSize=" + this.getIVSize() + ", kdfSize=" + this.getKdfSize() + "," + this.getTransformation() + ", blkSize=" + this.getCipherBlockSize() + "]";
            }
        }
        return this.s;
    }

    static interface CipherFactory {
        public javax.crypto.Cipher getCipher(String var1) throws GeneralSecurityException;
    }
}

