/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.sshd.common.compression.BaseCompression;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.util.buffer.Buffer;

public class CompressionZlib
extends BaseCompression {
    private static final int BUF_SIZE = 4096;
    private byte[] tmpbuf = new byte[4096];
    private Deflater compresser;
    private Inflater decompresser;

    public CompressionZlib() {
        this("zlib");
    }

    protected CompressionZlib(String name) {
        super(name);
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public void init(Compression.Type type2, int level) {
        this.compresser = new Deflater(level);
        this.decompresser = new Inflater();
    }

    @Override
    public void compress(Buffer buffer) throws IOException {
        this.compresser.setInput(buffer.array(), buffer.rpos(), buffer.available());
        buffer.wpos(buffer.rpos());
        int len2 = this.compresser.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2);
        while (len2 > 0) {
            buffer.putRawBytes(this.tmpbuf, 0, len2);
            len2 = this.compresser.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2);
        }
    }

    @Override
    public void uncompress(Buffer from2, Buffer to) throws IOException {
        this.decompresser.setInput(from2.array(), from2.rpos(), from2.available());
        try {
            int len2 = this.decompresser.inflate(this.tmpbuf);
            while (len2 > 0) {
                to.putRawBytes(this.tmpbuf, 0, len2);
                len2 = this.decompresser.inflate(this.tmpbuf);
            }
        }
        catch (DataFormatException e2) {
            throw new IOException("Error decompressing data", e2);
        }
    }
}

