/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.net.ProtocolException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.security.auth.login.FailedLoginException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface FilePasswordProvider {
    public static final FilePasswordProvider EMPTY = (session2, resourceKey, retryIndex) -> null;

    public String getPassword(SessionContext var1, NamedResource var2, int var3) throws IOException;

    default public ResourceDecodeResult handleDecodeAttemptResult(SessionContext session2, NamedResource resourceKey, int retryIndex, String password, Exception err) throws IOException, GeneralSecurityException {
        return ResourceDecodeResult.TERMINATE;
    }

    default public <T> T decode(SessionContext session2, NamedResource resourceKey, Decoder<? extends T> decoder) throws IOException, GeneralSecurityException {
        int retryCount = 0;
        while (true) {
            String pwd;
            if (GenericUtils.isEmpty(pwd = this.getPassword(session2, resourceKey, retryCount))) {
                throw new FailedLoginException("No password data for encrypted resource=" + resourceKey);
            }
            try {
                T result2 = decoder.decode(pwd);
                this.handleDecodeAttemptResult(session2, resourceKey, retryCount, pwd, null);
                return result2;
            }
            catch (IOException | RuntimeException | GeneralSecurityException e2) {
                ResourceDecodeResult result3 = this.handleDecodeAttemptResult(session2, resourceKey, retryCount, pwd, e2);
                if (result3 == null) {
                    throw e2;
                }
                switch (result3.ordinal()) {
                    case 0: {
                        throw e2;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return null;
                    }
                    default: {
                        throw new ProtocolException("Unsupported decode attempt result (" + (Object)((Object)result3) + ") for " + resourceKey);
                    }
                }
                ++retryCount;
                continue;
            }
            break;
        }
    }

    public static FilePasswordProvider of(String password) {
        return (session2, resource2, index) -> password;
    }

    public static enum ResourceDecodeResult {
        TERMINATE,
        RETRY,
        IGNORE;

        public static final Set<ResourceDecodeResult> VALUES;

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(ResourceDecodeResult.class));
        }
    }

    public static interface Decoder<T> {
        public T decode(String var1) throws IOException, GeneralSecurityException;
    }
}

